/*/

Clean ASM v1.01
  by : Peter Quiring

NEW v1.01 : Now comments are placed on col 41

/*/

//#define debug

#include <qlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <fcntl.h>
#include <mem.h>
#include <string.h>
#include <process.h>
#include <stdlib.h>

#include "misc.h"

//global data

#define lnmax 1024           //Max line length
#define inmax 64             //Max indentation

byte *bufi;
byte *bufo;
dword bip=0,bop=0;
dword bis=0,bos=0;

byte dat[lnmax];
byte remdat[lnmax];
byte EOFM=0;
byte REM=0;
byte OPENED=0;
sbyte indent=0;
sbyte addindent=0;
sbyte noindent;
byte indentsiz=2;      //default = 2
byte comment=0;
byte commentchar;
dword lnn=0;
byte *p1,*p1e,*p2;
byte didlabel;

int hi,ho;

byte enter[]={13,10,0};
byte empty[]={0};
byte temp[lnmax];

//code

void cleanup(void){
  if (OPENED) printf("Line : %d \n",lnn);
}

void readln(void) {
  byte a,*p=dat;
  int s;
  while (1) {
    if (bip==bis) {
      s=read(hi,bufi,bufsiz);
      if (s==0) {EOFM=1;*p=0;return;}
      if (s==-1) error("read error");
      bis=s;
      bip=0;
    }
    a=bufi[bip++];
    if (a==10) {*p=0;lnn++;return;}
    if (a!=13) *(p++)=a;
  }
}

void writeln(byte *p) {
  dword s;
  while (*p) {
    if (bop==bufsiz) {
      s=write(ho,bufo,bufsiz);
      if (s!=bufsiz) error("write error");
      bop=0;bos=0;
    }
    bufo[bop++]=*(p++);
    bos++;
  }
}

void writerem(void) {
  word i,l;
  byte *s;
  
  l=strlen(dat);
  if (l==0) goto cont;
  l+=indent;
  if (l<40) {
    i=40-l;
    s=temp;
    while (i) {*(s++)=' ';i--;}
    *s=0;
    writeln(temp);
  } else {
    writeln(" ");
  }

cont:

/*/
  i=(l+indent) % REMtabs;
  if ((i==0)&&(l>0)) i=REMtabs;

  s=temp;
  while (i) {*(s++)=' ';i--;}
  *s=0;
  writeln(temp);
/*/

  writeln(remdat);

}

void writeindent(void) {
  word a;
  byte *tmp;
  
  tmp=temp;
  for(a=0;a<indent;a++) *(tmp++)=' ';
  *tmp=0;

  writeln(temp);

}

void compln(void) {
  //compresses line

  byte q1=0,q2=0,*s=dat,*d;

  //convert all TABs to SPACEs (unless in a quote)
  while (*s) {
    if ((!q1)&&(!q2)&&(*s==9)) {*s=' ';continue;}
    if (*s=='\'') {
      if (q2) {s++;continue;}
      if (*(s+1)=='\'') {s+=2;continue;}  //ignore double quotes
      if (q1) q1=0; else q1=1;
      s++;
      continue;
    }
    if (*s=='\"') {
      if (q1) {s++;continue;}
      if (*(s+1)=='\"') {s+=2;continue;}  //ignore double quotes
      if (q2) q2=0; else q2=1;
      s++;
      continue;
    }
    s++;
  }

//  if (q1 || q2) error("Quote left open");

  //compress init SPACEs
  s=dat;
  d=dat;

  while (*s==' ') s++;

  if (s==d) return;  //not need to copy anything

  while (*s) *d++=*s++;
  *d=*s;  //copy NULL
}

void removerem(void) {
  byte q1=0,q2=0,*s=dat,*d=remdat;

  //search for a ';'
  while (*s) {
    if ((!q1)&&(!q2)&&(*s==';')) {
      REM=1;
      *s=0;
      s++;
      //copy from s to d
      *(d++)=';';
      while (*s) *d++=*s++;
      *d=*s;  //copy NULL
      return;
    }
    if (*s=='\'') {
      if (q2) {s++;continue;}
      if (*(s+1)=='\'') {s+=2;continue;}  //ignore double quotes
      if (q1) q1=0; else q1=1;
      s++;
      continue;
    }
    if (*s=='\"') {
      if (q1) {s++;continue;}
      if (*(s+1)=='\"') {s+=2;continue;}  //ignore double quotes
      if (q2) q2=0; else q2=1;
      s++;
      continue;
    }
    s++;
  }
}

void removespaces(void) {
  byte q1=0,q2=0,*s=dat,*d=dat;

  //search for a repeated ' ' and remove them (except one of course)
  while (*s) {
    if ( (!q1) && (!q2) && (*s==' ') && (*(s+1)==' ') ) {s++;continue;}
    if ((*s=='\'')&&(!q2)) {
      if (*(s+1)=='\'') {  //copy double quotes
        *d++=*s++;
        continue;
      } 
      if (q1) q1=0; else q1=1;
    }
    if ((*s=='\"')&&(!q1)) {
      if (*(s+1)=='\"') {s+=2;continue;}  //ignore double quotes
      if (q2) q2=0; else q2=1;
    }
    *d++=*s++;
  }
  *d=*s;  //Copy NULL
}

byte check(byte l) {
  byte *newdat;
  byte *s=dat;
  //check dat[] for special things

  if (!l) didlabel=0;

  if (!strlen(dat)) return 0;

  noindent=0;
  p1=dat;
  p1e=empty;
  p2=empty;

  //look for 1st space (p1e=that - 1)  (to look for labels)
  while (*s)
    if (*s==' ') {p1e=s-1;p2=s+1;break;} else s++;
  if (p1e==empty) p1e=s-1;

#ifdef debug
  printf(" p1 = \"%s\"\n",p1);
  printf(" p1e = \"%s\"\n",p1e);
  printf(" p2 = \"%s\"\n",p2);
#endif

  if ((*p1e==':')&&(!l)) {
#ifdef debug
  printf("thingy ");
#endif
    didlabel=1;
    *(p1e+1)=0;
    writeln(dat);
    writeln(enter);
    strcpy(dat,p2);   //may be empty!
#ifdef debug
  printf("dat = \"%s\"\n",dat);
#endif
    return 1;
  }

  //check for more special things

  if (!memicmp(p1,".IF",3)) {addindent=2;return 0;}
  if (!memicmp(p1,".ELSE",5)) {addindent=2;indent-=2;return 0;}
  if (!memicmp(p1,".ELSEIF",7)) {addindent=2;indent-=2;return 0;}
  if (!memicmp(p1,".ENDIF",6)) {indent-=2;return 0;}

  if (!memicmp(p1,".REPEAT",7)) {addindent=2;return 0;}
  if (!memicmp(p1,".WHILE",6)) {addindent=2;return 0;}
  if (!memicmp(p1,".BREAK",6)) {addindent=2;indent-=2;return 0;}
  if (!memicmp(p1,".CONTINUE",9)) {addindent=2;indent-=2;return 0;}
  if (!memicmp(p1,".ENDW",5)) {indent-=2;return 0;}
  if (!memicmp(p1,".UNTIL",6)) {indent-=2;return 0;}  //.UNTILCXZ too

  if (!memicmp(p1,"IF",2)) {addindent=2;return 0;}
  if (!memicmp(p1,"IFDEF",5)) {addindent=2;return 0;}
  if (!memicmp(p1,"IFNDEF",6)) {addindent=2;return 0;}
  if (!memicmp(p1,"ELSE",4)) {addindent=2;indent-=2;return 0;}
  if (!memicmp(p1,"ELSEIF",6)) {addindent=2;indent-=2;return 0;}
  if (!memicmp(p1,"ENDIF",5)) {indent-=2;return 0;}

  if (!memicmp(p2,"PROC ",5)) {addindent=2;return 0;}
  if (!memicmp(p2,"PROC,",5)) {addindent=2;return 0;}
  if (!memicmp(p2,"STRUCT ",7)) {addindent=2;return 0;}
  if (!memicmp(p2,"STRUC ",6)) {addindent=2;return 0;}
  if (!memicmp(p2,"SEGMENT ",8)) {addindent=2;return 0;}
  if (!memicmp(p2,"MACRO ",6)) {addindent=2;return 0;}
  if (!memicmp(p2,"MACRO,",6)) {addindent=2;return 0;}

  if (!memicmp(p2,"PROC\0",5)) {addindent=2;return 0;}
  if (!memicmp(p2,"STRUCT\0",7)) {addindent=2;return 0;}
  if (!memicmp(p2,"STRUC\0",6)) {addindent=2;return 0;}
  if (!memicmp(p2,"SEGMENT\0",8)) {addindent=2;return 0;}
  if (!memicmp(p2,"MACRO\0",6)) {addindent=2;return 0;}

  if (!memicmp(p1,"ENDM ",5)) {indent-=2;return 0;}
  if (!memicmp(p2,"ENDP ",5)) {indent-=2;return 0;}
  if (!memicmp(p2,"ENDS ",5)) {indent-=2;return 0;}

  if (!memicmp(p1,"ENDM\0",5)) {indent-=2;return 0;}
  if (!memicmp(p2,"ENDP\0",5)) {indent-=2;return 0;}
  if (!memicmp(p2,"ENDS\0",5)) {indent-=2;return 0;}

  if (*dat=='.') noindent=1;   //.386 .model .code .data etc.

  return 0;

}

void flush(void) {
  if (bos) write(ho,bufo,bos);
}

void dofile(void) {
  byte *s;
  while (!EOFM) {
#ifdef debug
    printf("indent = %d\n",indent);
    if (lnn>10) {flush();exit(0);}
#endif
    REM=0;
    readln();
    if (!comment) compln();
//check if COMMENT is here
    if (comment) {
      //look if the commentchar is there
#ifdef debug
  printf("comment dat = \"%s\"\n",dat);
#endif
      s=dat;
      while (*s) if (*(s++)==commentchar) comment=0;
    }
    else if (!memicmp(dat,"COMMENT",7)) {
      comment=1;
      commentchar=0;
      s=dat+7;
      //look for a char (besides ' ')
      while (*s) if (*s!=' ') {commentchar = *s;break;} else s++;
      if (!commentchar) error("Comment without char?");
    } else {
      removerem();
      removespaces();
      if (check(0)) check(1);
    }
    if (comment) {
      writeln(dat);
      writeln(enter);
    } else {
      if ( (!strlen(dat)) && (didlabel) ) {
#ifdef debug
  printf("thingy2\n");
#endif
      } else {
#ifdef debug
  printf("strlen(dat)=%d didlabel=%d\n",strlen(dat),didlabel);
#endif
        if ((indent) && (noindent==0)) writeindent();
        if (strlen(dat)) writeln(dat);
        if (REM) writerem();
        writeln(enter);
      }
    }
    indent+=addindent;
    if (indent < 0) error("Identation went neg?");
    if (indent > inmax) error("To many indentations (you messy slob)");
    addindent=0;
  }
}

void main(byte argc,byte **argv) {

  if ((argc<3)||(argc>4)) {
    printf("CleanASM v1.01 (32bit) by : Peter Quiring\n");
    printf("  Usage : CLEANASM <in_file> <out_file> [indent_size]\n");
    printf("    indent_size = 2 (default)\n");
    printf("    Note : All tabs are removed and replaced with spaces\n");
    printf("           so if you need these stupid tabs please use my\n");
    printf("           NOTAB utility to convert them to spaces first.\n");
    exit(0);
  }

  bufi=GetRam(bufsiz);
  bufo=GetRam(bufsiz);

  hi=open(argv[1],O_BINARY | O_RDONLY);
  if (hi==-1) error("unable to open in_file");
  ho=open(argv[2],O_BINARY | O_WRONLY | O_CREAT | O_TRUNC, S_IWRITE);
  if (ho==-1) error("unable to create out_file");

  if (argc>3) indentsiz = atoi (argv[3]);

  OPENED = 1;  //error beyond this pt print a line #

  dofile();

  flush();

  close(hi);
  close(ho);

}
