include src\qlib.inc
include string.inc

.data?  ;starts DWORD aligned
  ;used by sscanf & str2num
  _str2num_siz_ dd ?      ;this is how many letters str2num_* used from src

.code
;this is atol, atoh, atoo, etc.
str2num proc,s:dword,rax:byte
  local _neg:byte
  local raxhi:byte             ;rax above 10?
  local raxuc:byte,raxlc:byte  ;rax MAX chars
  local raxd:dword             ;for faster exec.

  pushad
  .if (rax < 2) || (rax > 36)  ;tolerance
    jmp bad
  .endif
  mov esi,s
@@:
  ;remove white spaces until we hit 1st non-white char
  lodsb
  cmp al,0
  jz bad
  cmp al,32 ;space
  jz @b
  cmp al,9  ;tab
  jz @b
  jmp start
bad:
  popad
  mov _str2num_siz_,0
  xor eax,eax
  ret
start:
  ;check for '0x' or '0X'
  mov ax,[esi-1]
  .if ax=='x0' || ax=='X0'   ;these are 0x and 0X
    inc esi
    lodsb
  .endif
  mov _neg,0
  .if al=='-'
    inc _neg
    lodsb
  .elseif al=='+'
    lodsb
  .endif
  .if (rax > 10)
    mov bl,rax
    add bl,'A'-11
    mov raxuc,bl    ;uppercase
    mov bl,rax
    add bl,'a'-11
    mov raxlc,bl    ;lowercase
    mov raxhi,1
  .else
    mov raxhi,0
  .endif
  xor ebx,ebx
  mov bl,rax
  mov raxd,ebx
  xor bl,bl
  mov edi,esi
  sub edi,2   ;move to char before 1st digit
@@:
  cmp al,0
  jz cont
  .if (al>='0') && (al<='9')
    jmp cont2
  .elseif (raxhi) && (al>='A') && (al<=raxuc)  
    jmp cont2
  .elseif (raxhi) && (al>='a') && (al<=raxlc)
    jmp cont2
  .endif
  jmp cont
cont2:
  inc bl
  jz bad   ;Crazy if there is 256 #s
  lodsb
  jmp @b
cont:
  cmp bl,10
  ja bad   ;to many digits!
  cmp bl,0
  jz bad   ;no digits (could happen eg: + w/o any #s )
  sub esi,2  ;ESI -> last char used
  mov _str2num_siz_,esi
  mov eax,s
  sub _str2num_siz_,eax 
  inc _str2num_siz_      ;total size!
  ;go backwards till esi=edi
  mov ebx,1
  xor ecx,ecx  ;total
  std    ;BACKWARDS
@@:
  xor eax,eax
  lodsb
  .if (al>='0') && (al<='9')
    sub al,'0'
  .elseif (raxhi) && (al>='A') && (al<=raxuc)  
    sub al,'A'-10
  .elseif (raxhi) && (al>='a') && (al<=raxlc)
    sub al,'a'-10              ;FIX v2.05 Beta #1 : was 'a'+10
  .else
    jmp done
  .endif
  mul ebx
  add ecx,eax
  mov eax,raxd
  mul ebx
  mov ebx,eax
  cmp esi,edi
  jnz @b
done:
  cld
  mov eax,ecx
  .if _neg
    neg eax
  .endif
  mov [esp+7*4],eax  ;Save EAX
  popad
  ret
str2num endp

_endseg

end

