include src\qlib.inc
include src\alloc.inc
include errno.inc
include alloc.inc
include string.inc

.code

; Fragmented Memory Manager

; All I do is keep simple 12 byte headers in front of each block of RAM.
; First 2 byte = signature.  Second = flags. (a junk byte here ). Then next dword
; is a pointer to the previous block header and the next dword is the size
; of this block.  Flags are used to tell if a block is free and/or last one.

; All alloc RAM will be dword aligned

malloc proc,siz:dword
  pushad
  cmp siz,0
  jnz @f
bad:
  popad
  mov errno,ENOMEM
  mov eax,NULL
  ret
corrupt:
  popad
  mov errno,ECONTR   ;memory blocks destroyed
  mov eax,NULL
  ret
@@:
  ;make sure alloc block is dword aligned
  add siz,3
  and siz,0ffffffffh-3
  ;search thru chain for best fit
  mov eax,_baseram  ;ram start
  test eax,eax
  je bad
  xor ebx,ebx   ;best fit location
  mov ecx,-1    ;best fit is ecx too much over siz
start:
  ifdef __MEM_CHK__
    cmp [eax].heads.magic,MB_SIG
    jne corrupt
  endif
  test [eax].heads.flgs,MB_FREE
  jnz ok3
next:
  test [eax].heads.flgs,MB_LAST
  jnz endsrc
  add eax,[eax].heads.siz
  add eax,sizeof heads
  jmp start
ok3:
  ;found one that's free
  mov edx,[eax].heads.siz
  sub edx,siz
  jb next ;too small
  ;found one big enough
  cmp edx,ecx
  jae next ;already got another that's better
  ;this one's better
  mov ecx,edx
  mov ebx,eax
  jmp next
endsrc:
  ;end of search
  test ebx,ebx
  jz bad
; EBX = pointer  ECX = # bytes over siz
;split ebx into 2 blocks:1st = used 2nd = free
  xor [ebx].heads.flgs,MB_FREE         ;remove free flag (it is SET currently)
  cmp ecx,MB_MINSIZE                   ;don't make a really small block
  ja ok4
;  add ecx,siz
;  mov [ebx].heads.siz,ecx              ;set size (all of it)
  add ebx,sizeof heads
  mov [esp].callstruct._eax,ebx        ;save EAX on stack
  popad
  ret
ok4:
  ;split EBX into 2 blocks now (1st = siz bytes, 2nd = ECX-sizeof heads bytes)
  mov edx,siz
  mov al,[ebx].heads.flgs
  and al,MB_LAST                   ;mask last flag
  xor [ebx].heads.flgs,al          ;remove last flag if it's there
  mov [ebx].heads.siz,edx          ;set size
  add edx,ebx
  add edx,sizeof heads
  mov [edx].heads.magic,MB_SIG
  mov [edx].heads.flgs,MB_FREE     ;free flag
  or [edx].heads.flgs,al           ;set if last
  mov [edx].heads.prev,ebx         ;set prev
  sub ecx,sizeof heads             ;may drop below MB_MINSIZE
  mov [edx].heads.siz,ecx          ;set size
  add ebx,sizeof heads
  mov [esp].callstruct._eax,ebx    ;save EAX on stack
  test al,MB_LAST
  jnz @f
  ;FIX : v2.11 Beta #1 : fix prev in next block after new block
  mov ebx,edx
  add ebx,[edx].heads.siz
  add ebx,sizeof heads
  mov [ebx].heads.prev,edx  
@@:
  popad
  ret
malloc endp

free proc,hnd:dword
  pushad
  mov eax,hnd
  test eax,eax
  jnz ok6
invalid:
  popad
  mov errno,EINVMEM  ;invalid memory handle
  mov eax,ERROR
  ret
corrupt:
  popad
  mov errno,ECONTR   ;memory blocks destroyed
  mov eax,ERROR
  ret
ok6:
  sub eax,sizeof heads

  ifdef __MEM_CHK__
    cmp [eax].heads.magic,MB_SIG
    jne corrupt
  endif

  mov ebx,[eax].heads.prev

  ;FIX : v2.11 Beta #1 : following tests were all wrong
  test ebx,ebx
  jz ok7  ;can not join with prev block
  ifdef __MEM_CHK__
    cmp [ebx].heads.magic,MB_SIG
    jne corrupt
  endif
  test [ebx].heads.flgs,MB_FREE
  jz ok7  ;can not join with prev block

  ;can join with prev block
  ifdef __MEM_SIG__
    mov [eax].heads.magic,0  ;clear unused signature
  endif
  mov dl,[eax].heads.flgs  ;must copy flags to prev block (Last flag)
  mov ecx,[eax].heads.siz
  add ecx,sizeof heads
  mov eax,ebx
  add [eax].heads.siz,ecx
  mov [eax].heads.flgs,dl  ;keep LAST flag
ok7: ;done joining with above block

  test [eax].heads.flgs,MB_LAST
  jnz ok8  ;can not join with next block
     ;FIX : v2.11 Beta #1 : was not checking if this was the last block

  mov ebx,eax
  add ebx,[eax].heads.siz
  add ebx,sizeof heads
  ifdef __MEM_CHK__
    cmp [ebx].heads.magic,MB_SIG
    jne corrupt
  endif
  test [ebx].heads.flgs,MB_FREE
  jz ok8                               ;next block is not free

  ifdef __MEM_SIG__
    mov [ebx].heads.magic,0  ;clear unused signature
  endif
  mov dl,[ebx].heads.flgs
  mov ecx,[ebx].heads.siz
  add ecx,sizeof heads
  add [eax].heads.siz,ecx
  mov [eax].heads.flgs,dl              ;keep LAST flag
ok8: ;done joining below
  or [eax].heads.flgs,MB_FREE          ;mark as free
  test [eax].heads.flgs,MB_LAST
  jnz @f
  ;FIX : v2.11 Beta #1 : fix prev of next block
  mov ebx,eax
  add ebx,[eax].heads.siz
  add ebx,sizeof heads
  mov [ebx].heads.prev,eax
@@:
  popad
  xor eax,eax
  ret
free endp

_endseg

end

