ifndef __COMPRESS_H__
__COMPRESS_H__ equ 0

COMP_OFLOW equ 128  ;recommended min # of bytes that dest must be larger
                    ;than src on call to CompressBuffer()

;/*/  Flags  /*/
COMP_NOSTORE equ 1   ;force compression even if buffer gets bigger, unless dest is too small
COMP_BLOCKSTART equ 2    ;Start to compress a portion of a file
COMP_BLOCKCONT equ  4    ;continue to compress the next block
COMP_BLOCKEND equ   8    ;compress last block of a file
;When the above is used the compression routine will maintain it's hash
;  tables between calls so that you can compress a file that can not
;  fit into memory all at once.  After each call you must copy the last
;  byte in the output buffer that was not used cause it may hold some
;  un-outputed bits.  See compress.txt for more help.

;/*/  Compression types  /*/
COMP_STORE equ 0      ;store compression  (simply copy)
COMP_LZ equ    1      ;LZ compression
;COMP_LZW equ   2      ;LZW compression

.code
CompressBuffer proto :dword,:dword,:dword,:dword,:dword,:dword
DecompressBuffer proto :dword,:dword,:dword
CompressBufferSize proto :dword    ;returns size of buffer if expanded
CompressSetLevel proto :dword    ;sets compression level

endif

