/* PACKIT v2.20

v2.20a - fixed some major bugs
v2.20 - can now specify what files to PACK
v2.11a - better Usage help
v2.11 - exits nicely if there are no files
v2.10 - can output header to another file (see pack.txt)
v2.01 - will no longer add fileout to itself if it already exists
v2.00 - 32bit version...
v1.00 - simple 16bit version...

*/

#include <qlib.h>
#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "misc.h"
#include "parse.h"

void cleanup(void) {}

byte fixer;

struct bufs{   //23 bytes
  byte fn[13];  //0-12
  word fh;      //always 0
  dword off;    //offset
  dword siz;    //size of file
}sample;

struct bufs *buf;  //it's an array malloc()'ed later

dword coff;  //current offset
word cbuf;
dword siz;
int hi,ho,t;
byte str[80];
byte *tbuf;
dword a;
word cnt;
dword head1=0x1a4b4150;   //"PAK",26
dword head2=0x1a484150;   //"PAH",26
byte fo[0x80];
byte gothdr=0;  //flag
byte fohdr[0x80];
byte mode=0;  //0=normal 1=output header to other file

struct ffblk ff;

void pack_files(int a) {
  if (findfirst(arg_names[a],&ff,0)) return;  //no files
  while (1) {
    strcpy(str,ff.ff_name);
    strupr(str);
    if (!strcmp(str,fo)) {     //do not pack fileout itself
      if (findnext(&ff)) break;
      continue;
    }
    if (!strcmp(str,fohdr)) {  //do not pack filehdr itself
      if (findnext(&ff)) break;
      continue;
    }
    t=open(str,O_BINARY | O_RDONLY);
    if (t==-1) {
      printf("Unable to open:%s",str);
      exit(0);
    }
    siz=filelength(t);
    close(t);
    memset(buf[cbuf].fn,0,13);
    strcpy(buf[cbuf].fn,str);
    buf[cbuf].fh=0;   //reserved for use after loaded
    buf[cbuf].off=coff;
    buf[cbuf].siz=siz;
    cbuf++;
    if (cbuf>=65000) {
      printf("File limit: 65000 files");
      exit(0);
    }
    coff+=siz;
    if (findnext(&ff)) break;
  }
}

void main(byte argc,byte **args) {

  dword siz;

  if (argc<2) {
    printf(" PACKIT v2.20a (32bit) by : Peter Quiring\n");
    printf(" Usage: PACKIT [options] fileout [filespecs...]\n");
    printf("   Options:\n");
    printf("     /h=<filehdr> : Generate PAH file instead of PAK\n");
    printf("   Notes : No Paths in filespecs are allowed!\n");
    printf(" Examples:\n");
    printf("   PACKIT ..\\MYPACK.PAK *.txt *.zip\n");
    printf("   PACKIT /h=..\\MYHEADER.HDR ..\\MYPACK2.PAH *.doc\n");
    printf("   PACKIT C:\\PACKS\\MYPACK3.PAK\n");
    exit(0);
  }

  buf=(void*)GetRam(sizeof(sample)*65000);
  tbuf=GetRam(bufsiz);

  //Parse thru arguments
  parse_args();
  if ((arg_optsc>1)||(arg_namesc<1)) error("Bad arguments");
  if (arg_namesc<2) {
    arg_names[1]="*.*";  //default to all files
    arg_namesc++;
  }
  if ((arg_optsc)&&(!stricmp(arg_opts[a][0],"h"))) {
    if (arg_opts[a][1]==NULL) error("Bad arguments");
    strcpy(fohdr,arg_opts[a][1]);
    mode=1;
  }

  strcpy(fo,arg_names[0]);
  strupr(fo);

  coff=0;    //current offset
  cbuf=0;    //current buffer

  printf("Gathering file info...");
  for (a=1;a<arg_namesc;a++) pack_files(a);
  printf("# files found=%d\n",cbuf);

  if (mode)
    ho=open(fohdr,O_BINARY|O_CREAT|O_TRUNC|O_RDWR, S_IWRITE);
  else
    ho=open(fo,O_BINARY|O_CREAT|O_TRUNC|O_RDWR, S_IWRITE);

  if (ho==-1) error("File I/O error");

  if (!mode) write(ho,&head1,4);

  write(ho,&cbuf,2);   //# of files (part of header)
  buf[cbuf].fn[0]=0;
  /* now create packfile output
  format =
    filename [13]
    handle [2]  ;not used in file
    offset [4]
    size [4]
  */
  if (mode) a=4;
  else a=6+cbuf*23;
  cbuf=0;
  while(buf[cbuf].fn[0]){
    buf[cbuf].off+=a;
    write(ho,&buf[cbuf],sizeof(buf[0]));
    cbuf++;
  }
  if (mode) {
    close(ho);
    ho=open(fo,O_BINARY|O_CREAT|O_TRUNC|O_RDWR, S_IWRITE);
    if (ho==-1) error("File I/O error");
    write(ho,&head2,4);
  }
  //output the actual files!
  cbuf=0;
  while(buf[cbuf].fn[0]){
    hi=open(buf[cbuf].fn,O_BINARY|O_RDONLY);
    while (1) {
      a=read(hi,tbuf,bufsiz);
      if (!a) break;
      write(ho,tbuf,a);
    }
    close(hi);
    printf("%s - done!\n",buf[cbuf].fn);
    cbuf++;
  }
  close(hi);
  printf("\nComplete!\n");
}
