ifndef __DOS_H__
__DOS_H__ equ 0

.code
int86 proto i:byte,rin:dword,rout:dword
int86x proto i:byte,rin:dword,rout:dword,sreg:dword
int386 proto i:byte,rin:dword,rout:dword
int386x proto i:byte,rin:dword,rout:dword,sreg:dword

truename proto :dword,:dword        ;DOS func 60h

open proto strg:dword,acc:word,:vararg
close proto hand:word
creat proto strg:dword,attr:word
_creat proto strg:dword,attr:word
read proto hand:word,buf:dword,len:dword
write proto hand:word,bur:dword,len:dword
lseek proto hand:word,pos:dword,typ:byte   ;0=start  1=current  2=end
tell proto hand:word
filelength proto hand:word
eof proto hand:word
ifndef __STDIO_H__
unlink proto strg:dword
endif
getdisk proto
setdisk proto drv:byte
mkdir proto strg:dword
chdir proto strg:dword
rmdir proto strg:dword
rename proto old:dword,new:dword
getcwd proto buf:dword
getdcwd proto drv:byte,buf:dword
findfirst proto str1:dword,ffb:dword,attr:word
findnext proto ffb:dword
fsplit proto :dword,:dword,:dword,:dword
getfattr proto :dword,:dword
setfattr proto :dword,:dword
chmod proto :dword,:dword

isatty proto :word

; LFN functions  (see \txt\lfn.txt)
lfn_findfirst proto str1:dword,allow_attr:byte,req_attr:byte,datetyp:word,lfn_ffb:dword
lfn_findnext proto hand:word,datetyp:word,lfn_ffb:dword
lfn_freefind proto hand:word
; NEW : v2.11 Beta #2 : following LFN functions are all new
lfn_open proto :dword,:word,:word
lfn_creat proto :dword,:word,:word
lfn_chdir proto :dword
lfn_mkdir proto :dword
lfn_rmdir proto :dword
lfn_unlink proto :dword
lfn_rename proto :dword,:dword
lfn_getcwd proto :dword
lfn_getdcwd proto :byte,:dword
; NEW : v2.11 Beta #5 : following LFN functions are all new
lfn_truename proto :dword,:dword

gettime proto :dword
settime proto :dword
getdate proto :dword
setdate proto :dword

sleep proto :word
delay proto :word
sound proto :word
nosound proto

.data
ifdef __MASM__
ffblk struct  ;used w/ findfirst & findnext
  ff_reserved db 21 dup (?)  ;reserved
  ff_attrib db ?
  ff_ftime dw ?
  ff_fdate dw ?
  ff_fsize dd ?
  ff_name db 13 dup (?)
ffblk ends

lfn_ffblk struct    ;used w/ lfn_findfirst() & lfn_findnext()
 ff_attrib dd ?
   ; file attributes
   ; bits 0-6 standard DOS attributes (FA_*)
   ; bit 8: temporary file
 ff_ct_lo dd ?      ; file creation time (number of 100ns intervals since 1/1/1601)
 ff_ct_hi dd ?
 ff_last_access_lo dd ? ; last access time
 ff_last_access_hi dd ?
 ff_last_modify_lo dd ? ; last modification time
 ff_last_modify_hi dd ?
 ff_fsize_hi dd ?     ; file size (high 32 bits)
 ff_fsize_lo dd ?     ; file size (low 32 bits)
 ff_reserved db 8 dup (?); reserved
 ff_full_name db 260 dup (?) ; ASCIZ full filename
 ff_short_name db 14 dup (?) ; ASCIZ short filename (for backward compatibility)
lfn_ffblk ends
endif

SEEK_SET equ 0  ; Seeks from beginning of file
SEEK_CUR equ 1  ; Seeks from current position
SEEK_END equ 2  ; Seeks from end of file

O_RDONLY equ 0
O_WRONLY equ 1
O_RDWR equ 2
O_APPEND equ 0800h
O_CREAT equ 0100h
O_CREATE equ 0100h  ; Canadian eh?
O_TRUNC equ 0200h
O_EXCL equ 0400h    ; Returns an error if file exists (O_CREAT)

O_CHANGED   equ 1000h  ; user may read these bits, but        
O_DEVICE    equ 2000h  ;   only RTL\io functions may touch.   
O_TEXT      equ 4000h  ; CR-LF translation    
O_BINARY    equ 8000h  ; no translation       

FA_NORMAL equ  000h        ;; Normal file, no attributes 
FA_RDONLY equ  001h        ;; Read only attribute 
FA_HIDDEN equ  002h        ;; Hidden file 
FA_SYSTEM equ  004h        ;; System file 
FA_LABEL  equ  008h        ;; Volume label 
FA_DIREC  equ  010h        ;; Directory 
FA_ARCH   equ  020h        ;; Archive 

;; Traditional names for bits in st_mode.
S_IFMT  equ 0F000h  ;; file type mask 
S_IFDIR equ 04000h  ;; directory 
S_IFIFO equ 01000h  ;; FIFO special 
S_IFCHR equ 02000h  ;; character special 
S_IFBLK equ 03000h  ;; block special 
S_IFREG equ 08000h  ;; or just equ0000, regular 
S_IREAD equ 00100h  ;; owner may read 
S_IWRITE equ 00080h ;; owner may write 
S_IEXEC equ 00040h  ;; owner may execute <directory search> 

;S_ISDIR(m)  ((m) and S_IFDIR)
;S_ISCHR(m)  ((m) and S_IFCHR)
;S_ISBLK(m)  ((m) and S_IFBLK)
;S_ISREG(m)  ((m) and S_IFREG)
;S_ISFIFO(m) ((m) and S_IFIFO)

S_IRWXU  equ 01c0h ;; RWE permissions mask for owner 
S_IRUSR  equ 0100h ;; owner may read 
S_IWUSR  equ 0080h ;; owner may write 
S_IXUSR  equ 0040h ;; owner may execute <directory search> 

LFN_DATE_64BIT equ 00
LFN_DATE_MSDOS equ 01

ifdef __MASM__
BYTEREGS struct
  _al db ?
  _ah db ?
  _1 dw ?
  _bl db ?
  _bh db ?
  _2 dw ?
  _cl db ?
  _ch db ?
  _3 dw ?
  _dl db ?
  _dh db ?
  _4 dw ?
BYTEREGS ends

WORDREGS struct
  _ax dw ?
  _1 dw ?
  _bx dw ?
  _2 dw ?
  _cx dw ?
  _3 dw ?
  _dx dw ?
  _4 dw ?
  _si dw ?
  _5 dw ?
  _di dw ?
  _6 dw ?
  cflag dw ?
  _7 dw ?
WORDREGS ends

DWORDREGS struct
  _eax dd ?
  _ebx dd ?
  _ecx dd ?
  _edx dd ?
  _esi dd ?
  _edi dd ?
  cflag dd ?
DWORDREGS ends

REGS union
  d DWORDREGS <>
  w WORDREGS <>
  h BYTEREGS <>
REGS ends

; NOTE: int86x() & int386x()  ignore ss and cs
SREGS struct
  _es dw ?
  _cs dw ?
  _ss dw ?
  _ds dw ?
  _fs dw ?
  _gs dw ?
SREGS ends
endif

date struct
  da_year dw ?     ; current year 
  da_day db ?      ; day of the month 
  da_mon db ?      ; month (1 = Jan) 
date ends

time struct
  ti_min db ?   ; minutes 
  ti_hour db ?  ; hours 
  ti_hund db ?  ; hundredths of seconds 
  ti_sec db ?   ; seconds 
time ends

endif

