#ifndef __PROFILER_H__
#define __PROFILER_H__

struct profiler_info {
  dword cnt1;    //IRQ1
  dword cnt2;    //Pentium cycle clock only  (any CPL)
  dword idx1dl;  //index 1 init data lo
  dword idx1dh;  //index 1 init data hi
  dword idx2dl;  //index 2 init data lo
  dword idx2dh;  //index 2 init data hi
  byte idx1;     //index 1 (Pentium MSR @ CPL0 only)
  byte idx2;     //index 2 
};

#ifdef __cplusplus
  extern "C" {
#endif

extern void profiler_init();
extern void profiler_start(struct profiler_info *);
extern void profiler_stop(struct profiler_info *);
extern void profiler_print(struct profiler_info *);
extern void profiler_uninit();

#ifdef __cplusplus
  }
#endif

#define pf_data_write  0      //Default
#define pf_data_read  1
#define pf_data_TLB_miss  2   //(translation look-aside buffer)
#define pf_data_read_miss  3
#define pf_data_write_miss  4
//5 write (hit) to M or E state lines
//6 data cache lines written back
//7 data cache snoops
//8 data cache snoop hits
//9 memory accesses in both pipes
//0Ah bank conflict
#define pf_misaligned  0x0B
//0Ch code read
//0Dh code TLB miss
//0Eh code cache miss
//0Fh segment load
//10h ????
//11h ????
#define pf_jmps  0x12
//13h BTB hits (Branch Target Buffer)
//14h taken branch OR BTB hit
#define pf_pipeline_flushes  0x15
//16h instructions executed
//17h instructions executed in V-pipe
//18h bus utilization (clocks)
//19h pipeline stalled by write backup
//1Ah pipeline stalled by data memory write
//1Bh pipeline stalled by write to E or M line
//1Ch locked bus cycles
//1Dh i/o read or write cycles
//1Eh non cacheable memory references
#define pf_AGI  0x1f    //(Address Generation Interlock)
//20h ????
//21h ????
//22h FPU operations
//23h breakpoint 0 match
//24h breakpoint 1 match
//25h breakpoint 2 match
//26h breakpoint 3 match
//27h hardware interrupts
//28h data read or data write
//29h data read miss or data write miss

#endif

