/*/

Build Incrementor v1.00   (by : Peter Quiring)

Build files should be (*.bld)

Build Format is (for ASM):
  ;;###
  build_num equ ###
  build_str equ '###'

Build Format is (for C):
  //###
  #define build_num ###
  #define build_str "###"

Input : The first line is read by QBUILD (the rest is ignored)
Output : Then QBUILD outputs as above.


If you edit those files make sure the FORMAT is exactly as above without
  the leading spaces or else QBUILD will not work.

If the file does not exist nothing will happen.

To "create" a Build file use:
  QBUILD /C<ASM,C> <filename>

To "reset" a Build file use:
  QBUILD /R <filename>

/*/

#include <qlib.h>
#include <string.h>
#include <stdio.h>
#include <dos.h>
#include <process.h>
#include <string.h>
#include <alloc.h>
#include <stdlib.h>

#include <misc.h>
#include "parse.h"

void cleanup(void) {}

int h;
dword num;
char type=' ';   //C or ASM
byte reset=0;
char buf[0x1000];
char *p=buf;

void usage(void) {
  printf("Usage : QBUILD [options] filename\n");
  printf("Options:\n");
  printf("--------\n");
  printf("  /ASM = Create ASM Build file if it does not exist\n");
  printf("  /C   = Create 'C' Build file if it does not exist\n");
  printf("  /R   = Reset counter to one\n");
  exit(0);
}

void ReadBuild(void) {

  memset(buf,0,0x1000);

  read(h,buf,0x1000);

  if (!memcmp(buf,";;",2)) type='A';
  else if (!memcmp(buf,"//",2)) type='C';
  else error("Invalid BUILD file");

  num=str2num(buf+2,10);

  if (!num) error("Invalid # in BUILD file");

}

void writeln(char *ss) {
  char str[0x80];
  char *s=str;

  sprintf(str,ss,num);

  while (*s) (*p++)=(*s++);
  (*p++)=13;
  (*p++)=10;
}

void writeln_asm(char *s) {
  dword t=num;
  char t2[16];
  int c=0;

  while (*s) (*p++)=(*s++);

  //now write # as '1','2','3', etc.

  while (t) {
    t2[c]= '0' + (t % 10);
    t/=10;
    c++;
  }

  while (c) {
    c--;
    (*p++)='\'';
    (*p++)=t2[c];
    (*p++)='\'';
    (*p++)=',';
  }

  p--;  //remove last comma

  (*p++)=13;
  (*p++)=10;
}

void WriteBuild(void) {
  switch (type) {
    case 'A':
      writeln(";;%u - Used by QBUILD");
      writeln("build_num equ %u");
      writeln_asm("build_str equ ");
      break;
    case 'C':
      writeln("//%u - Used by QBUILD");
      writeln("#define build_num %u");
      writeln("#define build_str \"%u\"");
  }
  if (write(h,buf,((dword)p)-((dword)buf))!=((dword)p)-((dword)buf))
    error("Write error?");
  close(h);
  exit(0);
}

void main(void) {

  print("\nQBUILD Incrementor v1.00 (by : Peter Quiring)\n");

  if (_argc<2) usage();
  
  parse_args();
  if (arg_namesc!=1) usage();
  if (arg_optsc>1) usage();
  if (arg_opts[0][1]!=NULL) usage();

  if (arg_optsc) {
    if (!stricmp(arg_opts[0][0],"C"))
      type='C';
    else if (!stricmp(arg_opts[0][0],"ASM"))
      type='A';
    else if (!stricmp(arg_opts[0][0],"R"))
      reset=1;
    else usage();
  }

  if (type==' ') {
    h=open(arg_names[0],O_BINARY | O_RDONLY);
    if (h==-1) error("Could not open BLD file");
    ReadBuild();
    close(h);
    unlink(arg_names[0]);
  } else {
    h=open(arg_names[0],O_BINARY | O_RDONLY);
    if (h==-1) num=0;
    else {
      ReadBuild();
      close(h);
      unlink(arg_names[0]);
    }
  }
  if (reset) num=0;
  num++;
  printf("Next Build # = %d\n",num);
  h=_creat(arg_names[0],FA_ARCH);
  if (h==-1) error("Could not create file");
  WriteBuild();
}
