include src\qlib.inc
include dpmi.inc
include alloc.inc

.code

_wrapper_int:
  push ds
  push es
  push fs
  push gs
  pushad
  mov ax,cs:seldata
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
  in al,60h
  mov ax,[esp+7*4]   ;restore AX
  db 0e8h  ;call 0xxxxxxxxh
_wrapper_int_1 equ $ - offset _wrapper_int
  dd ?     ;offset relative to next byte
  popad
  pop gs
  pop fs
  pop es
  pop ds
  sti
  iretd
_wrapper_int_size equ $ - offset _wrapper_int

;Common wrapper for RETF and IRET stack frames
_wrapper_cb:
  push ds   ;only ES:EDI,DS:ESI is needed
  push es
  push edi  
  push esi
  mov ax,cs:seldata
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
  db 0e8h  ;call 0xxxxxxxxh
_wrapper_cb_1 equ $ - offset _wrapper_cb
  dd ?     ;offset relative to next byte
  pop esi
  pop edi
  pop es
  pop ds
  db 0e9h  ;jmp 0xxxxxxxxh
_wrapper_cb_2 equ $ - offset _wrapper_cb
;  dd ?    ;omit this and save 4 bytes!
_wrapper_cb_size equ $ + 4 - offset _wrapper_cb

_DPMI_wrapper_int proc,h:dword
  pushad
  callp malloc,_wrapper_int_size
  or eax,eax
  .if zero?
    popad
    mov eax,ERROR
    ret
  .endif
  mov [esp+7*4],eax
  mov edx,eax
  mov esi,offset _wrapper_int
  mov edi,eax
  mov ecx,_wrapper_int_size
  copyECX  ;destroys AL
;Fixup CALL xxxxxxxxh
  mov ebx,h
  add edx,_wrapper_int_1
  sub ebx,edx
  sub ebx,4
  mov [edx],ebx
  popad
  ret
_DPMI_wrapper_int endp

_DPMI_wrapper_cb_retf proc,h:dword
  pushad
  mov edx,offset _DPMI_callback_retf
do_wrapper_cb::
  callp malloc,_wrapper_cb_size
  or eax,eax
  .if zero?
    popad
    mov eax,ERROR
    ret
  .endif
  mov [esp+7*4],eax
  mov esi,offset _wrapper_cb
  mov edi,eax
  mov ecx,_wrapper_cb_size
;Copy wrapper
  rep movsb   ;OPT! : can't opt AL needed
;Fixup CALL xxxxxxxxh
  mov ebx,h
  add eax,_wrapper_cb_1
  sub ebx,eax
  sub ebx,4
  mov [eax],ebx
;Fixup JMP xxxxxxxxh
  mov eax,[esp+7*4]
  add eax,_wrapper_cb_2
  sub edx,eax
  sub edx,4
  mov [eax],edx
  popad
  ret
_DPMI_wrapper_cb_retf endp

_DPMI_wrapper_cb_iret proc,h:dword
  pushad
  mov edx,offset _DPMI_callback_iret
  jmp do_wrapper_cb
_DPMI_wrapper_cb_iret endp

_endseg

end

