;****************************************************
; debug.inc
;****************************************************

PBYTE typedef PTR BYTE
ushort typedef WORD
ulong typedef DWORD
long typedef SDWORD
char typedef SBYTE
pchar typedef PTR SBYTE
uchar typedef BYTE

;*********************************************************
; 387 environment structure  (32bit protected mode format)
;*********************************************************

FPU_ENVIRONMENT STRUCT
  control dword ?
  status dword ?
  tag dword ?
  instr_ofs dword ?
  instr_sel dword ?
  operand_ofs dword ?
  operand_sel dword ?
  st0 real10 ?
  st1 real10 ?
  st2 real10 ?
  st3 real10 ?
  st4 real10 ?
  st5 real10 ?
  st6 real10 ?
  st7 real10 ?
FPU_ENVIRONMENT ENDS

program_reg STRUC
  prg_eax dword ?
  prg_ecx dword ?
  prg_edx dword ?
  prg_ebx dword ?
  prg_esp dword ?
  prg_ebp dword ?
  prg_esi dword ?
  prg_edi dword ?
  prg_eip dword ?
  prg_es dword ?
  prg_cs dword ?
  prg_ss dword ?
  prg_ds dword ?
  prg_fs dword ?
  prg_gs dword ?
  prg_eflags dword ?
  fpu_envir FPU_ENVIRONMENT <>
  ;mem_addr        dword          ?  ; Location of modified data, if any?
  ;mem_value       dword          ?  ; Value of modified data, if any?
  ;mem_type        dword          ?  ; size of modified data type
  ; 0=none, 1=byte, 2=word, 4=dword;
program_reg ENDS

SUPERSCRIPT_CHAR EQU 'S'    ;128
INSTR_POINTER_CHAR EQU ''  ;213
ARROWS_CHAR EQU ''         ;212

Number_brkpts EQU 80
Number_brkpts_string EQU <'80'>

externdef JMP_displacement :long
externdef MOD_RM_flag :byte
externdef MOD_RM_EffectiveAddress :dword
externdef MOD_RM_size :byte
externdef MOD_RM_DefaultSegmentReg :PBYTE
externdef MOD_RM_SegOveride :PBYTE

externdef print_float :near
externdef print_float2 :near

externdef getbyte : near
externdef getword : near
externdef getdword : near
externdef setbyte : near
externdef chk_location : near

Far_mem48 EQU 220
Real_mem32 EQU 221
Real_mem64 EQU 222
Real_mem80 EQU 223
Int_mem8 EQU 224
Int_mem16 EQU 225
Int_mem32 EQU 226
Int_mem64 EQU 227
BCD_mem80 EQU 228

NULL EQU 0
TRUE EQU 1
FALSE EQU 0
ON equ 1
OFF equ 0

move MACRO a1,a2
  push a2
  pop a1
ENDM


;************************************************************************
;
;                        Some  Macros
;
;************************************************************************


_f_setcolor macro x     ;;set color for flag display
  mov ah,registers_color
  .if which_window == FLAG_W
    .if flag_selected == &x
      mov ah,selected_color
    .endif
  .endif
endm

_d_setcolor macro x     ;;set color for data display
  mov ah,registers_color
  .if which_window == DATA_W
    .if data_selected == &x
      mov ah,selected_color
    .endif
  .endif
endm


draw_char MACRO char
  mov al,char
  call _draw_char
ENDM
draw_2char MACRO char
  mov bx,char
  call _draw_2char
ENDM
draw_vert MACRO char,count
  mov al,char
  mov cl, count
  call _draw_vert
ENDM
draw_horz MACRO char,count
  mov al,char
  mov cl, count
  call _draw_horz
ENDM
PlotStringOfs MACRO string
  mov edx,offset string
  call plot_string
ENDM

