#ifndef __SIGNAL_H__
#define __SIGNAL_H__

typedef short int sig_atomic_t;   // Atomic entity type (ANSI)  (16bit?)

#define SIG_DFL ((void (*)(int))0)       // Default action
#define SIG_IGN ((void (*)(int))1)       // Ignore action
#define SIG_ERR ((void (*)(int))-1)      // Error return

#define SIGPV   0               // Pure virtual func called (QLIB/C++ only)
#define SIGINT  1               // Ctrl+C or Ctrl+Brk  (INT 23h)
#define SIGILL  2               // Illegal instruction
#define SIGFPE  3               // Floating point trap
#define SIGSEGV 4               // Memory access violation
#define SIGTERM 5               // exit() called
#define SIGABRT 6               // abort() called
#define SIGUSER1 16              // user-defined exception
#define SIGUSER2 17              // user-defined exception
#define SIGUSER3 18              // user-defined exception
#define SIGUSER4 19              // user-defined exception

#ifdef __cplusplus
extern "C" {
extern int  raise(int __sig);
extern void (*signal(int __sig, void (* func)(int))) (int);
}
#else
extern int  raise(int __sig);
extern void (*signal(int __sig, void (* func)())) (int);
#endif

#endif
