// Do not include this file yourself!!!
// included by QLIB.H already!

#ifndef __QLIB_DEF_H__
#define __QLIB_DEF_H__

#ifdef __cplusplus
  extern "C" {
#endif

extern void _int3_(void);    //calls INT 3 (to easily place breakpts)
#define dos4gwint3 _int3_();

extern void irq_enable(byte a);
extern void irq_disable(byte a);

 //see pack.txt for explaination of everything below
extern sword pack_open(char *strg,...);       //allows reading of WAD type files
  ///... = header offset if it's a PAH file
extern sbyte pack_close(word);    //closes a packed file opened with pack_open()

extern byte _os_typ;              // see os.txt
extern byte _os_ver_major;
extern byte _os_ver_minor;
extern byte _dos_ver_major;
extern byte _dos_ver_minor;
extern word _dosXver;        //DOS extender version (binary value)
extern byte _dosXtyp;        //DOS extender type (0=PMODEW 1=DOS/4GW 2=DOS32)
  #define DOSX_PMODEW 0
  #define DOSX_DOS4GW 1
  #define DOSX_DOS32 2       //Obsolete DOS extender
  #define DOSX_WDOSX 3       //not detectable
  #define DOSX_UNKNOWN 0xff
extern word errno;        //last error code
extern word selcode;      // code selector
extern word seldata;      // data selector
extern dword _environ;  //linear addr to enviroment
extern dword _psp;      //linear addr to your PSP
extern dword _dta;      //linear addr to your DTA (it's not in your PSP)
extern dword _base;     //always 0 (PMODE rulez!)
extern byte _fpu;       // flag : 1=80387 or better present  0=otherwise */
extern byte _8087;      // for WATCOM compatibility
extern char _argstr;    // 129 dup (?)
extern char ** _argv;
extern byte _argc;
extern byte _pmmode;
  #define SRV_UNKNOWN 0xff
  #define SRV_DPMI 3
  #define SRV_VCPI 2
  #define SRV_XMS 1
  #define SRV_RAW 0
extern char *_filename;    //same as _argv[0]
extern word _ds_;          //these are loaded when certain INTs are called
extern word _es_;          // INT 10h,33h
extern word _pic_master;   // PIC Master vektor base
extern word _pic_slave;    // PIC Slave vektor base
extern word _8kbufferseg;  //RMODE seg     //free to use as you like
extern dword _8kbuffer;    //linear addr
extern byte _processor;    // processor type : 3=386 4=486 5=586
extern byte _cpu;          // processor type : same
extern byte _ansi_sys;     // Ansi.sys loaded?
extern byte _lfn;          // LFN support available?
extern byte _cpuid;        // CPUID present?
extern byte _mmx;          // MMX present?
extern byte _cpl;          // CPL (0 or 3)
extern byte _debugger;     // Q Debug,WD,DOS/4GW loaded?
extern byte _qdebug;       // Q Debug present?
extern void _qlib_video_cleanup(void);
extern char *_qlib_info;

extern sbyte NULLPROC(void);    //always returns 0
extern sbyte ERRORPROC(void);   //always returns -1

struct dma_s {
  dword siz;
  dword off;
  word sel;
  word id;
  dword phys;
  word dmach;
};  

// NOTE : these func auto take advantage of VDS (not yet)
// see DMA.TXT for explaintion of usage
extern sbyte dma_alloc64(struct dma_s *);    /*==ERROR if not avail  */
extern sbyte dma_alloc128(struct dma_s *);   /*==ERROR if not avail  */
extern sbyte dma_free(struct dma_s *);
extern sbyte dma_setup(struct dma_s *,dword bufstart,dword buflen,byte mode);

#define DMA_MODE_WRITE  0x48    //Write to device from memory (playback)
#define DMA_MODE_READ   0x44    //Read from device to memory (recode)
#define DMA_MODE_AUTO   0x10    //Auto. init. DMA mode

//Win95+ funcs
extern sbyte win95_title_set(const char * name);
extern sbyte win95_title_get(char * name,dword strsiz);
extern sbyte win95_vmtitle_set(const char * name);
extern sbyte win95_vmtitle_get(char * name,dword strsiz);
extern sbyte win95_close_enable(void);
extern sbyte win95_close_disable(void);
extern sbyte win95_close_query(void);
extern sbyte win95_close_ack(void);
extern sbyte win95_close_cancel(void);
#define WIN95_CLOSE_NOACK 0
#define WIN95_CLOSE_ACK 1

#ifdef __cplusplus
  }
#endif

#endif

