/*************************************************************************
** interpcom-1.1    (command interpreter)                                **
** interp.h      Command interpreter  	                                 **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#ifndef _INTERPCOM
#define _INTERPCOM

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include <ctype.h>
#include <time.h>
#include <stdarg.h>
#include <setjmp.h>




/*-------------------------------------------------------------------------
    This is the file "ee.h" of the Expression Evaluator of Mark Morley
-------------------------------------------------------------------------*/
/* Some of you may choose to define TYPE as a "float" instead... */
#define TYPE            double          /* Type of numbers to work with */

#define XVARLEN          15              /* Max length of variable names */
#define MAXXVARS         500              /* Max user-defined variables */
#define TOKLEN          30              /* Max token length */

#define XVAR             1
#define DEL             2
#define NUM             3

typedef struct
{
   char name[XVARLEN + 1];               /* Variable name */
   TYPE value;                          /* Variable value */
} XVARIABLE;

typedef struct
{
   char* name;                          /* Function name */
   int   args;                          /* Number of arguments to expect */
   TYPE  (*func)();                     /* Pointer to function */
} FUNCTION;

/* The following macros are ASCII dependant, no EBCDIC here! */
#define iswhite(c)  (c == ' ' || c == '\t')
#define isnumer(c)  ((c >= '0' && c <= '9') || c == '.')
#define isalphab(c)  ((c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') \
                    || c == '_' || c == 127)
#define isdelim(c)  (c == '+' || c == '-' || c == '*' || c == '/' || c == '%' \
                    || c == '^' || c == '(' || c == ')' || c == ',' || c == '=')

/* Codes returned from the evaluator */
#define E_OK           0        /* Successful evaluation */
#define E_SYNTAX       1        /* Syntax error */
#define E_UNBALAN      2        /* Unbalanced parenthesis */
#define E_DIVZERO      3        /* Attempted division by zero */
#define E_UNKNOWN      4        /* Reference to unknown variable */
#define E_MAXXVARS      5        /* Maximum variables exceeded */
#define E_BADFUNC      6        /* Unrecognised function */
#define E_NUMARGS      7        /* Wrong number of arguments to funtion */
#define E_NOARG        8        /* Missing an argument to a funtion */
#define E_EMPTY        9        /* Empty expression */


/*************************************************************************
**                                                                       **
** PROTOTYPES FOR CUSTOM MATH FUNCTIONS                                  **
**                                                                       **
 *************************************************************************/

double deg( double x );
double rad( double x );


/*************************************************************************
**                                                                       **
** XVARIABLE DECLARATIONS                                                 **
**                                                                       **
 *************************************************************************/

int   ERROR;                 /* The error number */
char  ERTOK[TOKLEN + 1];     /* The token that generated the error */
int   ERPOS;                 /* The offset from the start of the expression */
char* ERANC;                 /* Used to calculate ERPOS */

extern XVARIABLE Consts[];
extern FUNCTION Funcs[];

XVARIABLE        Vars[MAXXVARS];       /* Array for user-defined variables */
unsigned char*  expression;          /* Pointer to the user's expression */
unsigned char   token[TOKLEN + 1];   /* Holds the current token */
int             type;                /* Type of the current token */
jmp_buf         jb;                  /* jmp_buf for errors */


int
strlwr2( char* s );
/*-------- End of "ee.h" -------------------------------------------------*/




typedef struct FCOMPLEX {
    float           r,
                    i;
} fcomplex;
typedef struct DCOMPLEX {
    double          r,
                    i;
} dcomplex;
typedef struct FPOLAIRE {
    float           rm,
                    th;
} fpolaire;
typedef struct DPOLAIRE {
    double          rm,
                    th;
} dpolaire;

typedef struct _MEMM {
    int		       dim;
    char            ***ad;
    int                type;
    int		       prof;
} memm;

int             cmpt_mem,
                ind_mem;

typedef	  int		(*i_fonc)();
typedef   double	(*d_fonc)();
typedef   fcomplex	(*fc_fonc)();
typedef   dcomplex	(*dc_fonc)();
typedef   fpolaire	(*fp_fonc)();
typedef   dpolaire	(*dp_fonc)();

typedef struct T_FONC {
    i_fonc	F_i;
    d_fonc	F_d;
    fc_fonc	F_fc;
    dc_fonc	F_dc;
    fp_fonc	F_fp;
    dp_fonc	F_dp;
} T_fonc;

typedef struct CC_FONC {
    d_fonc	CF_d;
    d_fonc      PF_d;
} CC_fonc;

extern T_fonc T_add; 
extern T_fonc T_sub;
extern T_fonc T_mult;
extern T_fonc T_inv; 
extern T_fonc T_Rmul; 
extern T_fonc R_cnst;
extern T_fonc C_mul;
extern T_fonc C_cnst;
extern T_fonc Rpol_cnst; 
extern T_fonc Thpol_cnst;
extern T_fonc T_id;
extern T_fonc C_conjg;
extern T_fonc C_Complex;
extern T_fonc C_Polaire;
extern CC_fonc CC_Reel;
extern CC_fonc CC_R;
extern CC_fonc CC_Imag;
extern CC_fonc CC_Th;

#define TEST_ALLOC(x) null_alloc((char *)(x))
#define XFREE(x) Xfree_b((char **)(x))
#define _INITIALISE    0
#define _NONINITIALISE 1

#ifdef _MSDOS_VERSION
#include "unixfic.h"
#define fopen Xfopen
#endif

typedef int 	(*pfi)();
typedef char    *argv_t[20];
typedef char 	v_c[300];

typedef struct TYPE_OBJET {
    int		    type;
    int  	    nombre;
    int		    nbdim;
    char 	  **nom_dim;
    char	   *nom;
    char	   *comment;
} obj_typ;

typedef struct _OBJET {
    obj_typ	   *typ_obj;
    char           *adresse;
    int		    occup;
    char	   *nom_obj;
    int		   *dim;
} obj;
  

typedef struct TYPE_STRUC {
    int		    nb_membres;
    int		   *type_mb;
    char	  **membre_id;
    char	   *nom;
    char	   *comment;
    int		    nombre;
} struc_typ;

typedef struct _STRUC {
    char	   *nom_struc;
    int		    occup;
    struc_typ	   *type;
    char	  **nom_mb;
} strucb;


      


/*--------------------------------------------------------------------
----------------------------------------------------------------------
    Prototypes des fonctions
----------------------------------------------------------------------
--------------------------------------------------------------------*/
/*
 *   com_sys.c
 */
int		lookup_b(char *);
void		execute(int i, int argc, char *argv[]);
void		charge_com(char *, char int_ini_c[], int);
void		interp_com(FILE *, char *);
int		mode_cmd(FILE *, char *);
int		greet_cmd(FILE *, char *);
int             gr_cmd(FILE *, char *, char **, int *, int);
int		func_cmd(FILE *, char *);
int             mess_cmd(FILE *, char *);
int             test_param(int, int);
int		param_cmd(FILE *, char *);
int		var_cmd(FILE *, char *);
int		init_interp_cmd(FILE *, char *);
void	        exit_sys(void);
void		exit_interp(char *);
void		err_mess(int);
void		traite_label(void);
void		extrait_argv_com(int, int *, int, char *argv_com[]); 
void		supprime_ligne_com(int, int);
void		insere_ligne_com(int, int, char *);
int		exist_com(char *);
void		ch_prem(void);
int		est_avant(int, int);
void		echange_nom(int, int);
int		delprog_cmd(int argc, char *argv[]);
char		*__Xdecode(char xg[], int, char *);
void            __perms(char *, char *);
char		__chx(int);

/*
 *  command.c
 */
int 		bouclex(int argc, char *argv[]);
int 		bouclex_f(int argc, char *argv[]);
int		echo_cmd(int argc, char *argv[]);
int 		repetex(int argc, char *argv[]);
int 		editeur(int argc, char *argv[]);
int 		delcom(int argc, char *argv[]);
int 		deldon(int argc, char *argv[]);
int 		delres(int argc, char *argv[]);
int 		si_cmd(int argc, char *argv[]);
int 		is_cmd(int argc, char *argv[]);
int 		file_cmd(int argc, char *argv[]);
int 		close_file_cmd(int argc, char *argv[]);
int 		question_cmd(int argc, char *argv[]);
int 		var_list_cmd(int argc, char *argv[]);
int 		undef_cmd(int argc, char *argv[]);
int		echo_int_cmd(int argc, char *argv[]);
int		echo_float_cmd(int argc, char *argv[]);
int		fread_cmd(int argc, char *argv[]);
int		silence_cmd(int argc, char *argv[]);
int		rep_cmd(FILE *, char *);
int 		temps(int argc, char *argv[]);
int 		exit_cmd(int argc, char *argv[]);
int 		proglist_cmd(int argc, char *argv[]);
int 		load_cmd(int argc, char *argv[]);
int 		shell_cmd(int argc, char *argv[]);
void		init_var(void);
int		init_var_cmd(int argc, char *argv[]);
int		num_com(int argc, char *argv[]);
int		hist_cmd(int argc, char *argv[]);
int		mon_cmd(int argc, char *argv[]);
int		fin_mon_cmd(int argc, char *argv[]);
void            print(char*, ...);
int		flush_cmd(int argc, char *argv[]);
int		greetb_cmd(int argc, char *argv[]);
void		error_mess(int);
FILE           *Copen(char *, char *, char *);
FILE           *CCopen(char *, char *, char *, char *);
FILE           *CIopen(char *, char *, char *, int);
FILE           *fmemopen(void *, int, char *);
int		time_cmd(int argc, char *argv[]);

/*
 *   complex.c
 */
fcomplex        Cadd(fcomplex, fcomplex);
fcomplex        Csub(fcomplex, fcomplex);
fcomplex        Cnegat(fcomplex);
fcomplex        Cmul(fcomplex, fcomplex);
fcomplex        Complex(float, float);
fcomplex        Conjg(fcomplex);
fcomplex        Cdiv(fcomplex, fcomplex);
float           Cabs(fcomplex);
fcomplex        Csqrt(fcomplex);
fcomplex        RCmul(float, fcomplex);
fcomplex        RCdiv(fcomplex, float);
fcomplex        Cinv(fcomplex);
dcomplex        dCadd(dcomplex, dcomplex);
dcomplex        dCsub(dcomplex, dcomplex);
dcomplex        dCnegat(dcomplex);
dcomplex        dCmul(dcomplex, dcomplex);
dcomplex        dComplex(double, double);
dcomplex        dConjg(dcomplex);
dcomplex        dCdiv(dcomplex, dcomplex);
double          dCabs(dcomplex);
dcomplex        xdCsqrt(dcomplex);
dcomplex        dRCmul(double, dcomplex);
dcomplex        dRCdiv(dcomplex, double);
dcomplex        xdCinv(dcomplex);
fpolaire        Conv_ctp(fcomplex);
fcomplex        Conv_ptc(fpolaire);
dcomplex        dConv_ptc(dpolaire);
dpolaire        dConv_ctp(dcomplex);
fcomplex        Clog_p(fpolaire);
fcomplex	Clog_c(fcomplex);
fpolaire	Plog_c(fpolaire);
fcomplex        Csin_c(fcomplex);
fcomplex        Ccos_c(fcomplex);
fpolaire        Pexp_c(fcomplex);
fcomplex        Cexp_c(fcomplex);
fpolaire	Pexp_p(fpolaire);
dcomplex        dClog_p(dpolaire);
dcomplex	dClog_c(dcomplex);
dpolaire	dPlog_c(dpolaire);
dcomplex        dCsin_c(dcomplex);
dcomplex        dCcos_c(dcomplex);
dpolaire        dPexp_c(dcomplex);
dcomplex        dCexp_c(dcomplex);
dpolaire	dPexp_p(dpolaire);
fpolaire        Polaire(float, float);
dpolaire	dPolaire(double, double);
fpolaire	Padd(fpolaire, fpolaire);
fpolaire	Psub(fpolaire, fpolaire);
fpolaire	Pmul(fpolaire, fpolaire);
fpolaire	Pdiv(fpolaire, fpolaire);
fpolaire	Pconjg(fpolaire);
fpolaire	Psqrt(fpolaire);
fpolaire	Ppuis(fpolaire, float);
fcomplex	Cpuis(fcomplex, float);
fpolaire	RPmul(float, fpolaire);
fpolaire	RPdiv(fpolaire, float);
fpolaire	Pinv(fpolaire);
dpolaire	dPadd(dpolaire, dpolaire);
dpolaire	dPsub(dpolaire, dpolaire);
dpolaire	dPmul(dpolaire, dpolaire);
dpolaire	dPdiv(dpolaire, dpolaire);
dpolaire	dPconjg(dpolaire);
dpolaire	dPsqrt(dpolaire);
dpolaire	dPpuis(dpolaire, double);
dcomplex	dCpuis(dcomplex, double);
dpolaire	dRPmul(double, dpolaire);
dpolaire	dRPdiv(dpolaire, double);
dpolaire	dPinv(dpolaire);

/*
 *   ee.c
 */
int	 	SetValue(char *, double *);
int		Evaluate(char *, double *, int *);

/*
 *   interface
 */
void 		exit_prog(void);
void 		init_prog(void);
void		dest_prop(int, int);

/*
 *   interp.c
 */
void		prog_c(int argc, char *argv[], char *, char int_ini_c[], int);
void		lect_com(void);
void		extrait_arg(void);
void		execute_c(void);
int		change_lev();
void		substit(void);
void		substit2(void);
void		shell_c(int argc, char *argv[]);
int 		lookup_c(char *names[], char *, int *, int);
void		prTime(void);
double          (*fonc(char *))(double ,double);
int		convert_int(char *);
int		S_convert_int(char *);
double		convert_float(char *);
double		S_convert_float(char *);
int		eval_cmd(int argc, char *argv[]);
int 		is_alphab(char);
int		is_alphab_or_num(char);
int 		parse_com(char *, char *);
void		read_float(float *);
void 		read_int(int *);
void 		read_char(char *);
int 		parse_def(char *, int *, char *);
void		extrait_arg_s(char *, double *, int *);
dcomplex	calc_val_obj(int, double *, char *, int);

/*
 *   mem.c
 */
memm	       *memm_alloc(int *, int, int);
memm           *_M(char **);
char           *addr_eff(memm *);
char           *addr_eff_b(memm *);
void		Xfree(memm *);
void		Xfree_b(char **);
int		longueur(memm *M);
int		compare_tab(memm *, memm *);
int		compare_dim(memm *, memm *);
int            *int_alloc1(int);
int	      **int_alloc2(int, int);
int	     ***int_alloc3(int, int, int);
int	    ****int_alloc4(int, int, int, int);
float          *float_alloc1(int);
float	      **float_alloc2(int, int);
float	     ***float_alloc3(int, int, int);
float	    ****float_alloc4(int, int, int, int);
double            *double_alloc1(int);
double	      **double_alloc2(int, int);
double	     ***double_alloc3(int, int, int);
double	    ****double_alloc4(int, int, int, int);
fcomplex       *fcomplex_alloc1(int);
fcomplex      **fcomplex_alloc2(int, int);
fcomplex     ***fcomplex_alloc3(int, int, int);
fcomplex    ****fcomplex_alloc4(int, int, int, int);
dcomplex       *dcomplex_alloc1(int);
dcomplex      **dcomplex_alloc2(int, int);
dcomplex     ***dcomplex_alloc3(int, int, int);
dcomplex    ****dcomplex_alloc4(int, int, int, int);
fpolaire       *fpolaire_alloc1(int);
fpolaire      **fpolaire_alloc2(int, int);
fpolaire     ***fpolaire_alloc3(int, int, int);
fpolaire    ****fpolaire_alloc4(int, int, int, int);
dpolaire       *dpolaire_alloc1(int);
dpolaire      **dpolaire_alloc2(int, int);
dpolaire     ***dpolaire_alloc3(int, int, int);
dpolaire    ****dpolaire_alloc4(int, int, int, int);
void		manip1_tab(memm *, memm *, memm *, T_fonc *,
		double, dcomplex, int, CC_fonc*);
void		ajoute_tab(memm *, memm *, memm *);
void		soustrait_tab(memm *, memm *, memm *);
void		multiplie_tab(memm *, memm *, memm *);
void		Rmul_tab(memm *, double, memm *);
void		Cmul_tab(memm *, dcomplex, memm *);
void		Conjg_tab(memm *, memm *);
void		Module_tab(memm *, memm *);
void		Phase_tab(memm *, memm *);
void		copie_tab(memm *, memm *);
void		reel_tab(memm *, memm *);
void		imag_tab(memm *, memm *);
void		Polaire_tab(memm *, memm *, memm *);
void		Complex_tab(memm *, memm *, memm *);
void		cnst_tab(memm *, double);
void		Ccnst_tab(memm *, dcomplex);
void		RPolcnst_tab(memm *, double);
void		ThPolcnst_tab(memm *, double);
memm           *_M(char **);
int		svg_tab(FILE *, char *, int);

/*
 * objdef.c
 */
int		objdef_cmd(FILE *, char *);
void		nettoie(char *);
void		make_com(char *, int, int *);
int		obj_create(int argc, char *argv[]);
int		test_nom_obj(char *, int);
int		detruit_obj(int argc, char *argv[]);
int		liste_obj(int argc, char *argv[]);
void		init_obj(int);
int		sketch_obj(char *, int *);
int		sketch_obj_restr(char *, int *, int);
int		sketch_obj2(char *, char *, int *, int *);
int		sketch_obj3(char *, char *, char *,int *, int *, int *);
int		add_objet(int argc, char *argv[]);
int		sub_objet(int argc, char *argv[]);
int		copie_objet(int argc, char *argv[]);
int 		svg_cmd(int argc, char *argv[]);
int 		restore_cmd(int argc, char *argv[]);
int 		cnst(int argc, char *argv[]);
int		mult_objet(int argc, char *argv[]);
int		Cmult_objet(int argc, char *argv[]);
char	       *ch_copy(char *);
int 		Ccnst_cmd(int argc, char *argv[]);
int 		RPolcnst(int argc, char *argv[]);
int 		ThPolcnst(int argc, char *argv[]);
int		struct_cmd(FILE *, char *);
void		make_com_str(char *, int, int *);
int		test_nom_str(char *, int);
void		init_str(int);
int 		assign_membre(int argc, char *argv[]);
int 		desassign_membre(int argc, char *argv[]);
int		desc_struct(int argc, char *argv[]);
int		struc_create(int argc, char *argv[]);
int		sketch_struc(int, int, char *, int *);
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/



/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
#ifdef _DEF_PFI_INTERP
char		   *namesb[] = 
{
    "mode",
    "greet",
    "func",
    "message",
    "param",
    "var",
    "def",
    "rep",
    "struct",
    "init",
    ""
};

pfi 		    procb[] =
{
    mode_cmd,
    greet_cmd,
    func_cmd,
    mess_cmd,
    param_cmd,
    var_cmd,
    objdef_cmd,
    rep_cmd,
    struct_cmd,
    init_interp_cmd
};


#ifdef _ENG_LANG
char *mess_interp[] = 
{
    "Missing parameter",                                    /* 0    */
    "Incorrect file name",                                  /* 1    */
    "Incorrect numerical parameter",                        /* 2    */
    "Incorrect second parameter",                           /* 3    */
    "Too many conditional variables",                       /* 4    */
    "Too many open files",                                  /* 5    */
    "Non opened file",    				    /* 6    */
    "Incorrect question file",                              /* 7    */
    "Incorrect object name",				    /* 8    */
    "Too long object name",				    /* 9    */
    "Too many objects of this type",			    /* 10   */
    "Already used name",				    /* 11   */
    "Unknown object",					    /* 12   */
    "Incorrect number of object ore structure type",	    /* 13   */
    "Incorrect objects",				    /* 14   */
    "Incorrect saved object",	  			    /* 15   */
    "Too long structure name",				    /* 16   */
    "Too many structures of this type",			    /* 17   */
    "Unknown structure",				    /* 18   */
    "Incorrect member name",				    /* 19   */
    "Incorrect command file name\n",   	                    /* 20   */
    "Incorrect structure name",				    /* 21   */
    "Incorrect program file",	                            /* 22   */
    "Incorrect program file name",	                    /* 23   */
    "Unknown program",                                      /* 24   */
    "Incorrect command in this context",                    /* 25   */
    "Already used command name",                            /* 26   */
    "Too many lines",                                       /* 27   */
    "Unknown program",                                      /* 28   */
    "File already open for reading",			    /* 29   */
    "File already open for writing",			    /* 30   */

    ""
};

#else
/*  French messages */
char *mess_interp[] = 
{
    "Parametre manquant",                                   /* 0    */
    "Nom de fichier incorrect",                             /* 1    */
    "Parametre numerique incorrect",                        /* 2    */
    "Second parametre incorrect",                           /* 3    */
    "Trop de variables conditionnelles",                    /* 4    */
    "Trop de fichiers ouverts",                             /* 5    */
    "Fichier non ouvert",				    /* 6    */
    "Fichier de questions incorrect",                       /* 7    */
    "Nom d'objet incorrect",				    /* 8    */
    "Nom d'objet trop long",				    /* 9    */
    "Trop d'objets de ce type definis",			    /* 10   */
    "Nom deja utilise",					    /* 11   */
    "Objet inexistant",					    /* 12   */
    "Numero de type d'objet ou de structure incorrect",	    /* 13   */
    "Objets incorrects",				    /* 14   */
    "Objet enregistre incorrect",			    /* 15   */
    "Nom de structure trop long",			    /* 16   */
    "Trop de structures de ce type definies",		    /* 17   */
    "Structure inexistante",				    /* 18   */
    "Nom de membre incorrect",				    /* 19   */
    "Nom de fichier de commandes incorrect\n",              /* 20   */
    "Nom de structure incorrect",			    /* 21   */
    "Fichier de programme incorrect",                       /* 22   */
    "Nom de fichier de programme incorrect",                /* 23   */
    "Programme inconnu",                                    /* 24   */
    "Commande incorrecte dans ce contexte",                 /* 25   */
    "Nom de commande deja utilise",                         /* 26   */
    "Nombre de lignes trop grand",                          /* 27   */
    "Programme inexistant",                                 /* 28   */
    "Fichier deja ouvert en lecture",			    /* 29   */
    "Fichier deja ouvert en ecriture",			    /* 30   */

    ""
};
#endif

#endif
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
#ifdef _VERSION_INTERP
char *version = "interpcom V1.1 15/03/98";
#endif
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/




#define comp(s1,s2) (!strcmp((s1),(s2)))

int		prlevel,
                ind_run,
 		__nbcom,
                __nblignes,
		__com_max,
		__greet_max,
		__mess_max,
                __nss,
		__nmode_fonc,
		__maxvoice,
                __nbcond,
		__nbtypmax,
		__nbstrucmax,
		__nbargmax,
                __nbfoncmax,
                __nblabelmax,
		__max_quest,
		__n_com_prec,
		ind_x_mode,
		ind_x_func,
		ind_x_param,
		ind_x_rep;


extern	pfi	proc[];
extern 	pfi	procb[];
extern	char   *namesb[];
extern char    *mess_interp[];

char	      **mess,
	      **prompt_mode,
              **greet,
              **names,
	      **nom_com,
             ***ligne_com,
              **com_prec,
	       *argv_init_interp[20];

int	        ind_com,
                i_greet,
	       *nb_label,
               *tr_label,
	      **num_label,
               *len_n,
	       *sil_com,
	      **mode_com_int,
	      **mode_com_str,
	      **mode_com_obj,
               *nb_par,
		nb_com,
               *nb_lignes,
                horloge,
		nb_mode_fonc,
                nb_commandes,
                i_message,
              **mode_com,
               *par_com,
                is_com,
                i_speed,
		curvoice,	       /* numero de la 'voix' courante */
               *deb_nom,
	       *fin_nom,
		ix_com,
		pr_com,
		i_com,
                i_com_cur,
		i_ligne_cur,
		i_lec_cur,
                i_init_interp,
                sil_init_interp,
		argc_init_interp;
long		i_time_x;

FILE	      **inp;                   /* 'voix' ou sont lues les 
					  commandes. La voix 0 est
                                          stdin, les autres sont les
					  fichiers de commandes
                                          appeles successivement       */ 
argv_t	       *argv_x;                /* contient les arguments des
                                          appels de fichiers de 
					  commandes precedents         */
int	       *argc_x;                /* nombre d'arguments des
                                          appels de fichiers de 
					  commandes precedents         */

  
               
/*-------------------------------------------------------------------------
   variable utilisee par le "parser" d'argument numerique
-------------------------------------------------------------------------*/
char		hcom[1000];
/*-----------------------------------------------------------------------*/



/*-------------------------------------------------------------------------
   reconnaissances du contexte 
-------------------------------------------------------------------------*/
int             mode_fonct_;
/*-----------------------------------------------------------------------*/



/*-------------------------------------------------------------------------
   variables utilisees dans les commandes conditionnelles ('si' et 'is')
-------------------------------------------------------------------------*/
int		n_cond,
	       *s_cond;
v_c 	       *v_cond;
/*-----------------------------------------------------------------------*/



/*---- Ouverture et fermeture interactive de fichiers --------------------*/
FILE	      **sS,
	       *Mon_File;
int	       *sS_cmpt,
               *sS_i_o;
char	      **sS_nom;

/*------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------
    Chaines de caracteres contenant des reponses a des questions
    (cf. commande 'question')
--------------------------------------------------------------------------*/
char	      **ques;
/*------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------
    Chaine de caracteres contenant le nom du repertoire de commandes
--------------------------------------------------------------------------*/
char		command_rep[80],
		data_rep[80],
		data_rep2[80],
                result_rep[80];
/*------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------
    Creation d'objets
--------------------------------------------------------------------------*/
int		nb_typ;

obj_typ	       *Obj_typ;
obj	      **Obj;
/*------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------
    Creation de structures
--------------------------------------------------------------------------*/
int		nb_struc;

struc_typ      *Struc_typ;
strucb	      **Struc;
/*------------------------------------------------------------------------*/


#define _GOTO 5
#define _IFGT 6
#define _IFLT 7
#define _IFEQ 8
#define _EVAL 9
#define _PRIME_C 8803
#define _P_MULT 2743

#endif
