/*************************************************************************
** interpcom-1.1 (command interpreter)                                   **
** interp.h      mini-interpreter	                         	 **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#ifndef _INTERPCOM
#define _INTERPCOM

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include <ctype.h>
#include <time.h>
#include <stdarg.h>
#include <setjmp.h>




/*-------------------------------------------------------------------------
    This is the file "ee.h" of the Expression Evaluator of Mark Morley
-------------------------------------------------------------------------*/
/* Some of you may choose to define TYPE as a "float" instead... */
#define TYPE            double          /* Type of numbers to work with */

#define XVARLEN          15              /* Max length of variable names */
#define MAXXVARS         500              /* Max user-defined variables */
#define TOKLEN          30              /* Max token length */

#define XVAR             1
#define DEL             2
#define NUM             3

typedef struct
{
   char name[XVARLEN + 1];               /* Variable name */
   TYPE value;                          /* Variable value */
} XVARIABLE;

typedef struct
{
   char* name;                          /* Function name */
   int   args;                          /* Number of arguments to expect */
   TYPE  (*func)();                     /* Pointer to function */
} FUNCTION;

/* The following macros are ASCII dependant, no EBCDIC here! */
#define iswhite(c)  (c == ' ' || c == '\t')
#define isnumer(c)  ((c >= '0' && c <= '9') || c == '.')
#define isalphab(c)  ((c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') \
                    || c == '_' || c == 127)
#define isdelim(c)  (c == '+' || c == '-' || c == '*' || c == '/' || c == '%' \
                    || c == '^' || c == '(' || c == ')' || c == ',' || c == '=')

/* Codes returned from the evaluator */
#define E_OK           0        /* Successful evaluation */
#define E_SYNTAX       1        /* Syntax error */
#define E_UNBALAN      2        /* Unbalanced parenthesis */
#define E_DIVZERO      3        /* Attempted division by zero */
#define E_UNKNOWN      4        /* Reference to unknown variable */
#define E_MAXXVARS      5        /* Maximum variables exceeded */
#define E_BADFUNC      6        /* Unrecognised function */
#define E_NUMARGS      7        /* Wrong number of arguments to funtion */
#define E_NOARG        8        /* Missing an argument to a funtion */
#define E_EMPTY        9        /* Empty expression */


/*************************************************************************
**                                                                       **
** PROTOTYPES FOR CUSTOM MATH FUNCTIONS                                  **
**                                                                       **
 *************************************************************************/

double deg( double x );
double rad( double x );


/*************************************************************************
**                                                                       **
** XVARIABLE DECLARATIONS                                                 **
**                                                                       **
 *************************************************************************/

int   ERROR;                 /* The error number */
char  ERTOK[TOKLEN + 1];     /* The token that generated the error */
int   ERPOS;                 /* The offset from the start of the expression */
char* ERANC;                 /* Used to calculate ERPOS */

extern XVARIABLE Consts[];
extern FUNCTION Funcs[];

XVARIABLE        Vars[MAXXVARS];       /* Array for user-defined variables */
unsigned char*  expression;          /* Pointer to the user's expression */
unsigned char   token[TOKLEN + 1];   /* Holds the current token */
int             type;                /* Type of the current token */
jmp_buf         jb;                  /* jmp_buf for errors */


int
strlwr2( char* s );
/*-------- End of "ee.h" -------------------------------------------------*/






#ifdef _MSDOS_VERSION
#include "unixfic.h"
#define fopen Xfopen
#endif

typedef int 	(*pfi)();
typedef char    *argv_t[20];
typedef char 	v_c[300];


      


/*--------------------------------------------------------------------
----------------------------------------------------------------------
    Prototypes des fonctions
----------------------------------------------------------------------
--------------------------------------------------------------------*/
/*
 *   com_sys.c
 */
int		lookup_b(char *);
void		execute(int i, int argc, char *argv[]);
void		charge_com(char *, char int_ini_c[], int);
void		interp_com(FILE *, char *);
int		mode_cmd(FILE *, char *);
int		greet_cmd(FILE *, char *);
int             gr_cmd(FILE *, char *, char **, int *, int);
int		func_cmd(FILE *, char *);
int             mess_cmd(FILE *, char *);
int             test_param(int, int);
int		param_cmd(FILE *, char *);
int		var_cmd(FILE *, char *);
int		init_interp_cmd(FILE *, char *);
void	        exit_sys(void);
void		exit_interp(char *);
void		err_mess(int);
void		traite_label(void);
void		extrait_argv_com(int, int *, int, char *argv_com[]); 
void		supprime_ligne_com(int, int);
void		insere_ligne_com(int, int, char *);
int		exist_com(char *);
void		ch_prem(void);
int		est_avant(int, int);
void		echange_nom(int, int);
int		delprog_cmd(int argc, char *argv[]);
char		*__Xdecode(char xg[], int, char *);
void            __perms(char *, char *);
char		__chx(int);
void		nettoie(char *); 
char *		ch_copy(char *); 

/*
 *  command.c
 */
int 		bouclex(int argc, char *argv[]);
int 		bouclex_f(int argc, char *argv[]);
int		echo_cmd(int argc, char *argv[]);
int 		repetex(int argc, char *argv[]);
int 		editeur(int argc, char *argv[]);
int 		delcom(int argc, char *argv[]);
int 		deldon(int argc, char *argv[]);
int 		delres(int argc, char *argv[]);
int 		si_cmd(int argc, char *argv[]);
int 		is_cmd(int argc, char *argv[]);
int 		file_cmd(int argc, char *argv[]);
int 		close_file_cmd(int argc, char *argv[]);
int 		question_cmd(int argc, char *argv[]);
int 		var_list_cmd(int argc, char *argv[]);
int 		undef_cmd(int argc, char *argv[]);
int		echo_int_cmd(int argc, char *argv[]);
int		echo_float_cmd(int argc, char *argv[]);
int		fread_cmd(int argc, char *argv[]);
int		silence_cmd(int argc, char *argv[]);
int		rep_cmd(FILE *, char *);
int 		temps(int argc, char *argv[]);
int 		exit_cmd(int argc, char *argv[]);
int 		proglist_cmd(int argc, char *argv[]);
int 		load_cmd(int argc, char *argv[]);
int 		shell_cmd(int argc, char *argv[]);
void		init_var(void);
int		init_var_cmd(int argc, char *argv[]);
int		num_com(int argc, char *argv[]);
int		hist_cmd(int argc, char *argv[]);
int		mon_cmd(int argc, char *argv[]);
int		fin_mon_cmd(int argc, char *argv[]);
void            print(char*, ...);
int		flush_cmd(int argc, char *argv[]);
int		greetb_cmd(int argc, char *argv[]);
void		error_mess(int);
FILE           *Copen(char *, char *, char *);
FILE           *CCopen(char *, char *, char *, char *);
FILE           *CIopen(char *, char *, char *, int);
FILE           *fmemopen(void *, int, char *);
int		time_cmd(int argc, char *argv[]);

/*
 *   ee.c
 */
int	 	SetValue(char *, double *);
int		Evaluate(char *, double *, int *);

/*
 *   interface
 */
void 		exit_prog(void);
void 		init_prog(void);
void		dest_prop(int, int);

/*
 *   interp.c
 */
void		prog_c(int argc, char *argv[], char *, char int_ini_c[], int);
void		lect_com(void);
void		extrait_arg(void);
void		execute_c(void);
int		change_lev();
void		substit(void);
void		substit2(void);
void		shell_c(int argc, char *argv[]);
int 		lookup_c(char *names[], char *, int *, int);
void		prTime(void);
double          (*fonc(char *))(double ,double);
int		convert_int(char *);
int		S_convert_int(char *);
double		convert_float(char *);
double		S_convert_float(char *);
int		eval_cmd(int argc, char *argv[]);
int 		is_alphab(char);
int		is_alphab_or_num(char);
void		read_float(float *);
void 		read_int(int *);
void 		read_char(char *);
int             parse_def(char *, int *, char *);
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/



/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
#ifdef _DEF_PFI_INTERP
char		   *namesb[] = 
{
    "mode",
    "greet",
    "func",
    "message",
    "param",
    "var",
    "rep",
    "init",
    ""
};

pfi 		    procb[] =
{
    mode_cmd,
    greet_cmd,
    func_cmd,
    mess_cmd,
    param_cmd,
    var_cmd,
    rep_cmd,
    init_interp_cmd
};


#ifdef _ENG_LANG
char *mess_interp[] = 
{
    "Missing parameter",                                    /* 0    */
    "Incorrect file name",                                  /* 1    */
    "Incorrect numerical parameter",                        /* 2    */
    "Incorrect second parameter",                           /* 3    */
    "Too many conditional variables",                       /* 4    */
    "Too many open files",                                  /* 5    */
    "Non opened file",    				    /* 6    */
    "Incorrect question file",                              /* 7    */
    "Incorrect object name",				    /* 8    */
    "Too long object name",				    /* 9    */
    "Too many objects of this type",			    /* 10   */
    "Already used name",				    /* 11   */
    "Unknown object",					    /* 12   */
    "Incorrect number of object ore structure type",	    /* 13   */
    "Incorrect objects",				    /* 14   */
    "Incorrect saved object",	  			    /* 15   */
    "Too long structure name",				    /* 16   */
    "Too many structures of this type",			    /* 17   */
    "Unknown structure",				    /* 18   */
    "Incorrect member name",				    /* 19   */
    "Incorrect command file name\n",   	                    /* 20   */
    "Incorrect structure name",				    /* 21   */
    "Incorrect program file",	                            /* 22   */
    "Incorrect program file name",	                    /* 23   */
    "Unknown program",                                      /* 24   */
    "Incorrect command in this context",                    /* 25   */
    "Already used command name",                            /* 26   */
    "Too many lines",                                       /* 27   */
    "Unknown program",                                      /* 28   */
    "File already open for reading",			    /* 29   */
    "File already open for writing",			    /* 30   */

    ""
};

#else
/*  French messages */
char *mess_interp[] = 
{
    "Parametre manquant",                                   /* 0    */
    "Nom de fichier incorrect",                             /* 1    */
    "Parametre numerique incorrect",                        /* 2    */
    "Second parametre incorrect",                           /* 3    */
    "Trop de variables conditionnelles",                    /* 4    */
    "Trop de fichiers ouverts",                             /* 5    */
    "Fichier non ouvert",				    /* 6    */
    "Fichier de questions incorrect",                       /* 7    */
    "Nom d'objet incorrect",				    /* 8    */
    "Nom d'objet trop long",				    /* 9    */
    "Trop d'objets de ce type definis",			    /* 10   */
    "Nom deja utilise",					    /* 11   */
    "Objet inexistant",					    /* 12   */
    "Numero de type d'objet ou de structure incorrect",	    /* 13   */
    "Objets incorrects",				    /* 14   */
    "Objet enregistre incorrect",			    /* 15   */
    "Nom de structure trop long",			    /* 16   */
    "Trop de structures de ce type definies",		    /* 17   */
    "Structure inexistante",				    /* 18   */
    "Nom de membre incorrect",				    /* 19   */
    "Nom de fichier de commandes incorrect\n",              /* 20   */
    "Nom de structure incorrect",			    /* 21   */
    "Fichier de programme incorrect",                       /* 22   */
    "Nom de fichier de programme incorrect",                /* 23   */
    "Programme inconnu",                                    /* 24   */
    "Commande incorrecte dans ce contexte",                 /* 25   */
    "Nom de commande deja utilise",                         /* 26   */
    "Nombre de lignes trop grand",                          /* 27   */
    "Programme inexistant",                                 /* 28   */
    "Fichier deja ouvert en lecture",			    /* 29   */
    "Fichier deja ouvert en ecriture",			    /* 30   */

    ""
};
#endif

#endif
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
#ifdef _VERSION_INTERP
char *version = "interpcom V1.0 15/01/98";
#endif
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/




#define comp(s1,s2) (!strcmp((s1),(s2)))

int		prlevel,
                ind_run,
 		__nbcom,
                __nblignes,
		__com_max,
		__greet_max,
		__mess_max,
                __nss,
		__nmode_fonc,
		__maxvoice,
                __nbcond,
		__nbargmax,
                __nbfoncmax,
                __nblabelmax,
		__max_quest,
		__n_com_prec,
		ind_x_mode,
		ind_x_func,
		ind_x_param,
		ind_x_rep;


extern	pfi	proc[];
extern 	pfi	procb[];
extern	char   *namesb[];
extern char    *mess_interp[];

char	      **mess,
	      **prompt_mode,
              **greet,
              **names,
	      **nom_com,
             ***ligne_com,
              **com_prec,
	       *argv_init_interp[20];

int	        ind_com,
                i_greet,
	       *nb_label,
               *tr_label,
	      **num_label,
               *len_n,
	       *sil_com,
	      **mode_com_int,
               *nb_par,
		nb_com,
               *nb_lignes,
                horloge,
		nb_mode_fonc,
                nb_commandes,
                i_message,
              **mode_com,
               *par_com,
                is_com,
                i_speed,
		curvoice,	       /* numero de la 'voix' courante */
               *deb_nom,
	       *fin_nom,
		ix_com,
		pr_com,
		i_com,
                i_com_cur,
		i_ligne_cur,
		i_lec_cur,
                i_init_interp,
                sil_init_interp,
		argc_init_interp;
long		i_time_x;

FILE	      **inp;                   /* 'voix' ou sont lues les 
					  commandes. La voix 0 est
                                          stdin, les autres sont les
					  fichiers de commandes
                                          appeles successivement       */ 
argv_t	       *argv_x;                /* contient les arguments des
                                          appels de fichiers de 
					  commandes precedents         */
int	       *argc_x;                /* nombre d'arguments des
                                          appels de fichiers de 
					  commandes precedents         */

  
               
/*-------------------------------------------------------------------------
   variable utilisee par le "parser" d'argument numerique
-------------------------------------------------------------------------*/
char		hcom[1000];
/*-----------------------------------------------------------------------*/



/*-------------------------------------------------------------------------
   reconnaissances du contexte 
-------------------------------------------------------------------------*/
int             mode_fonct_;
/*-----------------------------------------------------------------------*/



/*-------------------------------------------------------------------------
   variables utilisees dans les commandes conditionnelles ('si' et 'is')
-------------------------------------------------------------------------*/
int		n_cond,
	       *s_cond;
v_c 	       *v_cond;
/*-----------------------------------------------------------------------*/



/*---- Ouverture et fermeture interactive de fichiers --------------------*/
FILE	      **sS,
	       *Mon_File;
int	       *sS_cmpt,
               *sS_i_o;
char	      **sS_nom;

/*------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------
    Chaines de caracteres contenant des reponses a des questions
    (cf. commande 'question')
--------------------------------------------------------------------------*/
char	      **ques;
/*------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------
    Chaine de caracteres contenant le nom du repertoire de commandes
--------------------------------------------------------------------------*/
char		command_rep[80],
		data_rep[80],
		data_rep2[80],
                result_rep[80];
/*------------------------------------------------------------------------*/



#define _GOTO 5
#define _IFGT 6
#define _IFLT 7
#define _IFEQ 8
#define _EVAL 9
#define _PRIME_C 8803
#define _P_MULT 2743

#endif
