#include <stdio.h>
#include <dos.h>
#include <conio.h>

/**** DEFINES ********************************************/

#define VGA_256                         0x13
#define TEXT_MODE                       0x03
#define PALETTE_MASK                    0x3C6
#define PALETTE_READ                    0x3C7
#define PALETTE_WRITE                   0x3C8
#define PALETTE_DATA                    0x3C9


/**** TYPE DEFINITIONS ***********************************/

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

/**** STRUCTURES *****************************************/

typedef struct
{
   BYTE red;
   BYTE green;
   BYTE blue;

} RGB;

/**** FUNCTION PROTOTYPES ********************************/

void SetVideoMode(BYTE mode);
int SetPalette(char *filename);
void ShowBitmap(char *filename);

/**** SET VIDEO MODE *************************************/

void SetVideoMode(BYTE mode)
{
   union REGS inregs, outregs;

   /* SELECT BIOS SERVICE SET VIDEO MODE */

   inregs.h.ah = 0;
   inregs.h.al = mode;

   /* CALL THE BIOS */

   int86(0x10, &inregs, &outregs);

}/* End function */


/**** SET PALETTE *****************************************/
  
int SetPalette(char *filename)
{
   FILE *fp;
   int counter, index=0;
   RGB color;

   /* ATTEMPT TO OPEN THE FILE PASSED BY THE CALLER */

   fp = fopen(filename, "rb");
      if(!fp) return 0;

   /* HERE WE WILL FIRST OUTPUT THE HEX BYTE FF WHICH */
   /* TELLS THE VGA CARD WE WANT ACCESS TO ALL 256 OF */
   /* COLOR REGISTERS.  THEN WE OUTPUT THE INDEX OF   */
   /* THE FIRST COLOR REGISTER WE WANT TO UPDATE.     */

   outp(PALETTE_MASK, 0xFF);
   outp(PALETTE_WRITE, index);

   /* UPDATE ALL THE REGISTERS */

   for(counter=0; counter<256; counter++)
   {
      /* READ IN THREE BYTES FROM THE PALETTE FILE */

      color.red = (unsigned char) (fgetc(fp) >> 2);
      color.green = (unsigned char) (fgetc(fp) >> 2);
      color.blue = (unsigned char) (fgetc(fp) >> 2);

      /* OUTPUT THE RGB VALUES TO THE CURRENT COLOR REGISTER */

      outp(PALETTE_DATA, color.red);
      outp(PALETTE_DATA, color.green);
      outp(PALETTE_DATA, color.blue);

      /* WHEN WE'VE WRITTEN THREE BYTES SELECT THE NEXT REGISTER */

      index++;
      outp(PALETTE_WRITE, index);

   }/* End for */

   /* CLOSE THE FILE AND RETURN SUCCESS */

   fclose(fp);
   return 1;

}/* End function */



/**** SHOW BITMAP ****************************************/


void ShowBitmap(char *filename)
{
   FILE *fp;
   BYTE far *video_buffer = (char far *) 0xA0000000L;
   DWORD width, height;
   WORD size;
   WORD offset=0, counter=0, x;

   /* OPEN THE FILE FOR BINARY READING */

   fp = fopen(filename, "rb");

   /* READ IN THE WIDTH AND HEIGHT OF THE IMAGE */

   fread(&width, sizeof(DWORD), 1, fp);
   fread(&height, sizeof(DWORD), 1, fp);
   size = width * height;

   /* SHOW THE PICTURE */

   for(x=0; x<size; x++)
   {
      video_buffer[offset] = (BYTE) fgetc(fp);
      counter++;
      offset++;

      if(counter == width)
      {
         offset += (320 - width);
         counter = 0;
      }
   }

   /* CLOSE THE DATA FILE */

   fclose(fp);

}/* End function */

/**** MAIN ***********************************************/

void main(void)
{
   /* SET THE VIDEO MODE TO 13h */

   SetVideoMode(VGA_256);

   /* SET THE PALETTE */

   SetPalette("palette.dat");

   /* DISPLAY THE BITMAP */

   ShowBitmap("bitmap.dat");

   /* WAIT FOR A KEYPRESS */

   while(!kbhit());

   /* RETURN TO TEXT MODE AND QUIT */

   SetVideoMode(TEXT_MODE);

}/* End function */

