@echo off
echo.
echo Ŀ
echo  Unpack, test, or view any kind of archive         
echo  Copyright by Prof. Timo Salmi Thu 27-Aug-92       
echo  Email: ts@uwasa.fi  WWW: http://www.uwasa.fi/~ts/ 
echo 

rem When one writes many utilities, getting new ideas is the more critical
rem part than the actual programming. Sometimes it is difficult to pinpoint
rem where exactly the ideas come from, but this one clearly owes an
rem acknowledgement to the posting by John LaRue (7 Mar 90) in the InterNet
rem news in comp.binaries.ibm.pc.d for the general idea. All the details,
rem the idea of using switches and using the file list, and the actual
rem programming are entirely my own, though.

if "%1"=="" goto _help

for %%f in (%1) do if "%1"=="%%f" goto :_testext
echo.
echo Wildcards not allowed in %1
set _choice=_usage
goto _usage

:_testext
rem Check that no extension was used
set _exten=%1
:_nextchar
set _prev=%_exten%
for %%f in (/%_exten%) do set _exten=%%f
if ".%_exten%"=="%_prev%" goto _extfound
if not "%_exten%"=="%_prev%" goto _nextchar
goto _noext

:_extfound
echo.
echo    ******** NO EXTENSION ALLOWED ********* 
set _choice=_usage
goto _usage

:_noext
rem Get the archive name, the parameters, and the filenames
set _choice=_usage
set _archive=%1
set _files=
:_loop
shift
if "%1"=="" goto %_choice%
if "%1"=="/e" set _choice=_extract
if "%1"=="/e" goto _loop
if "%1"=="/E" set _choice=_extract
if "%1"=="/E" goto _loop
if "%1"=="/t" set _choice=_test
if "%1"=="/t" goto _loop
if "%1"=="/T" set _choice=_test
if "%1"=="/T" goto _loop
if "%1"=="/v" set _choice=_view
if "%1"=="/v" goto _loop
if "%1"=="/V" set _choice=_view
if "%1"=="/V" goto _loop
set _files=%_files% %1
goto _loop

:_extract
set _return=_extr1
goto _subru
:_extr1
if "%_type%"=="arc" pkunpak -e %_archive%.arc %_files%
if "%_type%"=="zip" pkunzip %_archive%.zip %_files%
if "%_type%"=="lzh" lha e %_archive%.lzh %_files%
if "%_type%"=="zoo" zoo e %_archive%.zoo %_files%
if "%_type%"=="pak" pak e %_archive%.pak %_files%
if "%_type%"=="sdn" pak e %_archive%.sdn %_files%
if "%_type%"=="arj" arj e %_archive%.arj %_files%
goto _out

:_test
set _return=_test1
goto _subru
:_test1
if "%_type%"=="arc" pkunpak -t %_archive%.arc %_files%
if "%_type%"=="zip" pkunzip -t %_archive%.zip %_files%
if "%_type%"=="lzh" lha t %_archive%.lzh %_files%
if "%_type%"=="zoo" zoo -test %_archive%.zoo %_files%
if "%_type%"=="pak" pak t %_archive%.pak %_files%
if "%_type%"=="sdn" pak t %_archive%.sdn %_files%
if "%_type%"=="arj" arj t %_archive%.arj %_files%
goto _out

:_view
set _return=_view1
goto _subru
:_view1
if "%_type%"=="arc" pkunpak -v %_archive%.arc %_files%
if "%_type%"=="zip" pkunzip -v %_archive%.zip %_files%
if "%_type%"=="lzh" lha v %_archive%.lzh %_files%
if "%_type%"=="zoo" zoo v %_archive%.zoo %_files%
if "%_type%"=="pak" pak v %_archive%.pak %_files%
if "%_type%"=="sdn" pak v %_archive%.sdn %_files%
if "%_type%"=="arj" arj v %_archive%.arj %_files%
goto _out

rem Subroutine for identifying the archive type and parsing the archive name
rem If the same archive has been packed with several methods .arc takes
rem precedence, then .zip, and so on
:_subru
set _type=
if exist %_archive%.arj set _type=arj
if exist %_archive%.sdn set _type=sdn
if exist %_archive%.pak set _type=pak
if exist %_archive%.zoo set _type=zoo
if exist %_archive%.lzh set _type=lzh
if exist %_archive%.zip set _type=zip
if exist %_archive%.arc set _type=arc
if "%_type%"=="" goto _notfound
goto %_return%

rem Archive does not exist
:_notfound
echo.
echo File %_archive%.arc[.zip.lzh.zoo.pak.sdn.arj] not found
set _choice=_usage
goto _usage

:_help
:_usage
echo.
echo Usage: UNPACK ArchiveName [FileNames] { /e : /t : /v }
echo                                                   view contents
echo                                               test integrity
echo                                           extract files
echo ĿĿ
echo  Archive name: NO WILDCARDS! NO EXTENSION!  One switch must be chosen 
echo 
if "%_choice%"=="_usage" goto _out
echo.
echo Examples: UNPACK b:\tsutil35 /v d*.exe
echo.
echo Before you can use this batch, you must make the following programs
echo available at your path (or include the relevant paths in the batch):
echo pkunpak.exe, pkunzip.exe, lha.exe, pak.exe, zoo.exe, and arj.exe.
echo.
echo If you get an "Out of environment space" message, increase your
echo environment space by using shell configuration in config.sys:
echo MsDos 3.30 example: shell=c:\bin\command.com /e:1024 /p
goto _out

:_out
set _choice=
set _archive=
set _files=
set _type=
set _return=
set _exten=
set _prev=
echo on
