; <<< CUTPARAM.ASM >>> (c) Ph.Dalleur 1989-2000

; Ce programme DOS sert  dcouper un paramtre de la ligne
; de commande d'un fichier par lot (*.BAT) pour sparer le nom
; et l'extension du fichier. Compilation par NASM.EXE
; (voir http://www.cryogen.com/Nasm pour plus d'information),
; mais est facilement adaptable  d'autres (MASM, ASM, TASM, etc.)
; Voir README.TXT pour les informations et conditions.

[BITS 16]
[ORG 0x0100]   ;adresse initiale 0100h. Fichier .COM

section .text		;Main code

	mov bx,[80h]    ; ==== voir s'il existe un paramtre ====
	cmp bl,1
	ja prg
	mov dx,info
	mov al,5        ;Errorcode 5 => pas de paramtre
	push ax
	jmp affich2
prg:
	cld
	mov ah,62h      ;Lire le PSP (en ES)
	int 21h
	mov es,bx
	mov dx,[es:16h] ;programme parent
	mov ah,52h      ;Lire le DIB
	int 21h
	mov ax,es
	dec ax
	mov es,ax
	add bx,0Eh
	mov bx,[es:bx]  ;Lire le 1er MCB
	mov es,bx

MCBAT:
	cmp [ES:0],byte 5Ah ; Dernier MCB ?
	je ERR
	cmp [es:10h],byte 0 ;Batch ID? = 00
	jne nextMCB
	cmp [es:1],dx
	je MCB
nextMCB:
	add bx,[es:3]
	inc bx
	mov es,bx
	jmp MCBAT
MCB:
	mov cx,[es:3]
	shl cl,1
	shl cl,1
	shl cl,1
	shl cl,1
	inc bx          ;dbut Batch allou par MCB
	mov es,bx
	xor ax,ax
	mov di,ax
	mov si,ax       ;dbut de zone de recherche de ".BAT"
	add si,7        ; (celle-ci varie selon la version DOS)
	mov di,BAT      ;chercher la chane ".BAT"
	xchg si,di
	lodsb
BAT_:
	repnz scasb
	jcxz erreur
	rep cmpsb
	cmp si,bat_ok
	jz MCB_Ok       ;voir si la chane correspond
	mov si,1+BAT
	jmp BAT_
erreur:
ERR:
	mov dx,errMCB
	mov al,4        ; Errorcode 4 => Erreur MCB
	jmp affiche

BAT:                    ; Inline DATA.
 db ".BAT", 0, 0
bat_ok:
MCB_Ok:
	std
	dec di
	mov bx,di
	sub di,6
	mov cx,di       ;chercher dbut de table des paramtres
	dec cx
	dec cx
notyet:
	inc di
	mov ax,bx
	repnz scasb
	jcxz ERR        ;Le MCB n'est pas du type Batch => erreur MCB.
	xor ax,ax
	dec cx
	dec cx
	dec di
	scasw
	jnz notyet
	cld
	add di,4
	xor bx,bx
	mov bl,[82h]    ;lire le n du paramtre N
	and bl,0Fh
	mov dx,bx       ;sauver le n en DX
	shl bx,1
	mov si,di       ;Rfrence de table en SI
	mov bx,[es:bx+di]
	or bx,bx
	jge ok
	mov dx,messn
	mov al,3        ;Errorcode 3
affiche:
	add [code],al
	push ax
	mov ah,9
	int 21h
	mov dx,Errcode
affich2:
	mov ah,9
	int 21h
	pop ax
	mov ah,4Ch      ;terminer
	int 21h

ok:
	mov di,bx      ;rfrence du paramtre en DI
	mov cx,80      ;Longueur maximale de 80 caractres
        mov ah,0Dh     ;Carriage return CR
        mov al,[83h]   ;Caractre de coupure
        cmp al,' '     ;S'il est <=  blanc, on prend dfault = '.'
        ja recherch
	mov al,2Eh     ;Extension (2E = '.')
recherch:
	scasb          ; caractre = point ?
	jz extension   ;OUI => extension
;	cmp byte [es:di-1],'"'    ;comparer avec '"'
;	jnz noguill
;	mov byte [es:di-1],' '    ;remplacer par blanc
;noguill:	
	cmp [es:di-1],ah     ;Fin de chane (caractre CR = AH) ?
	loopnz recherch
	mov al,2        ;Errorcode 2
extension:
	mov byte[es:di-1],0Dh     ;mettre le dlimiteur de paramtre
	sub dx,9        ;changer la table des paramtres
	jc _9par
	mov dx,mess_9
	mov al,1        ;Errorcode 1
	jmp affiche

_9par:
	not dx
	mov cx,dx       ;compteur
	mov dx,di       ;rfrence de l'extension en DX
	add si,10h      ;initialiser adresse du changement de table
	mov di,si
	inc di
	inc di
	std
	es rep movsw
	xchg dx,ax
	cmp dl,2        ;Errorcode 2 (pas d'extension)
	jnz chgTbl
	dec ax
	stosw
	mov ax,dx
	mov dx,messdir  ;Trouv sans extension
	jmp affiche

chgTbl:
	stosw
	mov dx,messok
	mov al,0        ;Errorcode 0
	jmp affiche

;        *** DONNEES ***
section .data

messn:
    db " Parameter not found or absent$"
mess_9:
    db " > 9 parameters : extension lost$"
messok:
    db " Separation$"
messdir:
    db " Without extension. $"
errMCB:
    db "Error : MCB of BATch file not found$"
Errcode:
    db " (Error code: "
code:
    db "0 )",13,10,"$"
info:
    db 13,10,"         CUTPARAM - (C) Ph.Dalleur",13,10
    db "         _________________________",13,10,10
    db " This program called in a Batch File will split one of the command"
    db 13,10," line parameters of the batch file.",13,10,10
    db " Use:  cutparam [N[c]] [>redirection]",13,10,10
    db "   where",13,10,"   N = 0..9 is the number of the parameter to split",13,10
    db "   c = optional splitting caracter (defaulted to period '.')",13,10
    db "   Redirection to NUL is possible to eliminate the Error messages",13,10,10
    db " See examples in the file CUTPARAM.DOC.",13,10,10,"$"
