;************************************************************************
;*                      DumpEnv 1.0 (C) RonSoft.                        *
;*                                                                      *
;*      A simple utility that shows the ENVIRONMENT variables.          *
;*                                                                      *
;*      Ronald Nordberg                                                 *
;*      Silvervgen 3                                                   *
;*      907 50 Ume                                                     *
;*      SWEDEN                                                          *
;*      christine.martinson@swipnet.se                                  *
;*      http://home2.swipnet.se/~w-20064                                *
;*                                                                      *
;*      ALL PUBLIC DOMAIN FREEWARE.                                     *
;*      LET E'M KNOW IF YOU USE MY CODE.                                *
;*                                                                      *
;************************************************************************

[BITS 16]                               ;NASM stuff
[ORG 100h]

        mov     es,[es:+2Ch]            ;ES=PSP environment segment
        xor     di,di                   ;no offset
        cmp     byte [es:di],0          ;no vars ?
        je      quit                    ;yeahh, skip this

floop:                                  
        push    ds                      ;save those so we can print stuff
        push    si                      ;in our own segment
        mov     ax,es                   ;make DS:SI point to string we found
        mov     ds,ax                   ;copy seg
        mov     si,di                   ;and offset
        mov     bx,si                   ;work reg for print
        call    write                   ;show it

        pop     si                      ;restore those
        pop     ds
        mov     bx,newline              ;a CR and a LF
        call    write                   ;write it out
                                
flop:   inc     byte di                 ;next byte
        cmp     byte [es:di],0          ;a 0 ?
        je      next                    ;yeahh, check if two
        jmp     flop                    ;noo, dump next
next:   inc     byte di                 ;get next byte
        cmp     byte [es:di],0          ;two in a row ?
        je      quit                    ;nooo way
        jmp     floop                   ;show next variable
                   
quit:
        mov     ax,4c00h
        int     21h
          
;*************************************************************************
;*       Writes out the NULL terminated text supplied in BX.             *
;*       OR writes out data,BX and size,CX if called at lwrite.          *
;*************************************************************************
write:  pusha
        mov     si,bx                   ;copy to SI
        mov     cx,0                    ;clear count
wloop:  lodsb                           ;load AL with SI
        cmp     al,0                    ;end of line ?
        je      lwrite                  ;yeahh
        inc     cx                      ;no, incrase byte count
        jmp     wloop                   ;test next byte
lwrite: mov     dx,bx                   ;text address in DX
        mov     bx,1                    ;filehandle standard output = 1
        mov     ah,40h                  ;MS-DOS writefile with handle is 040
        int     21h                     ;write buffer to standard output
        popa
        ret                             ;done

newline db      13,10,0
mytext  db      'Ronald Nordberg.',13,10,0
 
          END
