	title	CONSOLIO -- Copyright 1997, Morten Elling
	subttl	Simple console Input/Output (DOS/Win32)

	include	model.inc
	include	modelt.inc
	include consolio.ash
	include consolio.inc	; Get DOS/Win32 definitions

	@CODESEG
	locals

	ife @isWin32	; ----- DOS section ---------------------------

;//////////////////////////////////////////////////////////////////////
;//	Name	IsDevRedir					  (DOS)
;//	Desc	Test redirection of standard input or standard output.
;//
;//
;//	Entry	Passed arg
;//	Exit	Acc > 0: Is redirected.
;//		Acc = 0: Not redirected.
;//		Acc =-1: Error on DOS call.

IsDevRedir proc
arg	hDev	:@uint		; Device handle (STDIN or STDOUT)
@uses	rbx,rdx
;.
	mov   ax, [hDev]
	cmp   ax, STDOUT
	ja sh @@err
	xchg  bx, ax
	mov   ax, 4400h 	; Get Device Data (into dx)
	int   21h
	jc sh @@err
	lea   ax, [bx+81h]
	and   dl, al		; Isolate bits 7,0 (STDOUT: 7,1)
	cmp   dl, al
	mov   ax, 0
	jz sh @@ret		; Has original device attributes
	inc   ax		; Has changed
	jmp sh @@ret
@@err:	or    ax, -1
@@ret:	RET
IsDevRedir endp


;//////////////////////////////////////////////////////////////////////
;//	Name	GetKey 						  (DOS)
;//	Desc	(Wait for and) Read character from the standard input
;//		device (usually the keyboard).
;//
;//
;//	Entry	N/A
;//	Exit	Acc = keyboard code (al zero if extended key).
;//
;//	Note	Checks for Ctrl-C and Ctrl-Break.

GetKey	proc
;.
	mov   ah, 08h		; Read Keyboard Without Echo
	int   21h
	sub   ah, ah		; Assume normal key
	test  al, al
	jnz sh @@ret
	mov   ah, 08h		; Was extended; read again
	int   21h
	mov   ah, al
	sub   al, al
@@ret:	RET
GetKey	endp


;//////////////////////////////////////////////////////////////////////
;//	Name	WriteZStr					  (DOS)
;//	Desc	Write zero-terminated Ascii string to standard output.
;//
;//
;//	Entry	Passed arg
;//	Exit	Acc = No. of bytes written.

WriteZStr proc
arg	pStr	:dataptr	; Addr of AsciiZ string
@uses	ds,rbx,rcx,rdx
;.
	@LDS  dx, [pStr]
	mov   bx, dx
	sub   al, al
	dec   bx
@@waz:	inc   bx
	cmp   al, [bx]		; End of string?
	jnz   @@waz
	mov   cx, bx
	sub   cx, dx		; String length, less 0
	jz sh @@ret
	mov   bx, STDOUT
	mov   ah, 40h		; Write File or Device
	int   21h
	mov   cx, ax		; ax = output length
@@ret:	mov   ax, cx
	RET
WriteZStr endp


;//////////////////////////////////////////////////////////////////////
;//	Name	WriteNL 					  (DOS)
;//	Desc	Write new-line (one CR/LF pair) to standard output.
;//
;//
;//	Entry	N/A
;//	Exit	Acc = No. of bytes written.

WriteNL	proc
@uses	rbx,rcx,rdx
;.
	if @isStackFar
	push  ds
	@LDSEGM ds, ss
	endif
	mov   ax, 0dh + 0ah shl 8
	push  ax
	mov   dx, sp
	mov   cx, 2
	mov   bx, STDOUT
	mov   ah, 40h		; Print the stack
	int   21h		; ax = output length
	pop   cx		; Clean up stack
	if @isStackFar
	pop   ds
	endif
	RET
WriteNL	endp


	else	; ----- Win32 section ---------------------------------


;//////////////////////////////////////////////////////////////////////
;//	Name	IsDevRedir					(Win32)
;//	Desc	Test redirection of standard input or standard output.
;//
;//
;//	Entry	Passed arg
;//	Exit	Acc > 0: Is redirected.
;//		Acc = 0: Not redirected.
;//		Acc =-1: Error on Win32 API call.
;//
;//	Note	Returns 0 if stdout redirected to LPTn (COMn?)
;//		or if a DOS box is running under Win95 v4.00.950a.
;//
;//	ToDo	Make this work as the DOS version!

IsDevRedir proc
arg	hDev	:@uint		; STD_INPUT_HANDLE or STD_OUTPUT_HANDLE
;.
; ----- Return handle to current standard input/output
;	(may have been redirected)
        mov   eax, [hDev]
	cmp   eax, STD_INPUT_HANDLE
	je sh @@idr1
	cmp   eax, STD_OUTPUT_HANDLE
	jne sh @@err
@@idr1: call  GetStdHandle, eax
	test  eax, eax
	jz sh @@err

; ----- See what file type
	call  GetFileType, eax
	cmp   eax, FILE_TYPE_CHAR
	setnz al		; Set flag if not console
	and   eax, 1
	jmp sh @@ret

@@err:  or    eax, -1
@@ret:	RET
IsDevRedir endp


;//////////////////////////////////////////////////////////////////////
;//	Name	GetKey 						(Win32)
;//	Desc	(Wait for and) Read character from the standard input
;//		device (usually the keyboard).
;//
;//
;//	Entry	N/A
;//	Exit	Acc = keyboard code.
;//
;//	Note	Doesn't read extended keys (function or arrow keys).
;//		Returns Ctrl-C as 03h (but Ctrl-Break is handled by
;//		Windows).

GetKey	proc
local	@@mode	:dword, \
	@@rbuf	:dword, \
	@@rlen	:dword
@uses	rsi,rbx,rdx
;.
	call  GetStdHandle, STD_INPUT_HANDLE
	mov   ebx, eax

; ----- Set device in 'raw' mode
	lea   esi, [@@mode]
	call  GetConsoleMode, ebx, esi
	mov   eax, [esi]
	and   eax, NOT (ENABLE_LINE_INPUT or ENABLE_ECHO_INPUT \
		or ENABLE_PROCESSED_INPUT)
	call  SetConsoleMode, ebx, eax

; ----- Read std. input device
	lea   edx, [@@rbuf]
	lea   eax, [@@rlen]
	call  ReadFile, ebx, edx, 1, eax, NULL

; ----- Restore device mode
	mov   eax, [esi]
	call  SetConsoleMode, ebx, eax

; ----- Return key
	mov   eax, [@@rbuf]	; ReadFile buffer contents
	and   eax, 0ffh
	RET
GetKey	endp


;//////////////////////////////////////////////////////////////////////
;//	Name	WriteZStr					(Win32)
;//	Desc	Write zero-terminated Ansi string to standard output.
;//
;//
;//	Entry	Passed arg
;//	Exit	Acc = No. of bytes written.

WriteZStr proc
arg	pzStr	:dataptr	; Addr of AnsiZ string
@uses	rbx,rcx,rdx
;.
	call  GetStdHandle, STD_OUTPUT_HANDLE
	mov   ebx, eax

; ----- Get string length
	mov   edx, [pzStr]
	lea   ecx, [edx-1]
	sub   eax, eax
@@w1:	inc   ecx
	cmp   al, [ecx]
	jnz   @@w1
	sub   ecx, edx
	jz sh @@ret

; ----- Do the output
	push  eax		; Allocate local var
	mov   eax, esp
	call  WriteFile, ebx, \
		edx, ecx, eax, NULL
	pop   ecx		; ecx = output length
@@ret:	xchg  eax, ecx
	RET
WriteZStr endp


;//////////////////////////////////////////////////////////////////////
;//	Name	WriteNL 					(Win32)
;//	Desc	Write new-line (one CR/LF pair) to standard output.
;//
;//
;//	Entry	N/A
;//	Exit	As for WriteZStr
;//     Calls   WriteZStr

WriteNL proc
@uses	rcx
;.
	push  00000a0dh 	; Ansi CR/LF string
	call  WriteZStr, esp
	pop   rcx		; Remove string
	RET
WriteNL endp

	endif

	END