	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Reverse the sign of a packed signed BCD number

	include	model.inc
	include	modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdNeg
;//	Desc	Reverse the sign of a packed signed BCD number.
;//
;//
;//	Entry	Passed args
;//	Exit	Accumulator (and cf,zf,sf flags) determined:
;//		Acc = -1: Number became negative
;//		Acc =  0: Number is zero
;//		Acc = +1: Number became positive
;//
;//	Note	Disregards sign of zero.

bcdNeg	proc
arg	dstBCD	:dataptr, \	; Addr of BCD
	dstsz	:@uint		; Byte size of BCD
@uses	ds,rsi,rcx
;.
	@LDS  rsi, [dstBCD]
	mov   rcx, [dstsz]
	dec   rcx		; All but the sign byte
	sub   rax, rax		; Zero accumulator
	@alignn
@@nxt:	mov   al, [rsi]		; Get a BCD byte
	inc   rsi		; Step pointer
	or    ah, al		; OR into ah
	loopz @@nxt		; Keep going until non-zero byte
	jz sh @@ret		; Zero: return acc=0,cf=0,zf=1,sf=0
	add   rsi, rcx		; Point to sign byte
	or    rax, -1		; Assume result negative
	xor   @bptr [rsi], 80h	; Flip sign bit
	stc			; Set carry
	js sh @@ret		; Negative: acc=-1,cf=1,zf=0,sf=1
	add   rax, 2		; Positive: acc=+1,cf=1,zf=0,sf=0
@@ret:	RET
bcdNeg	endp

	END