	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Load packed signed BCD constants

	include	model.inc
	include	modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdLdz
;//	Desc	Load zero as a packed BCD value.
;//
;//
;//	Entry	Passed args
;//	Exit	Destination = zero. Acc undefined.

bcdLdz	proc
arg	dstBCD	:dataptr, \	; Addr of destination BCD
	dstsz	:@uint		; Byte size of dest.
@uses	es,rdi,rcx,rax
;.
	@cld
	@LES  rdi, [dstBCD]
	mov   rcx, [dstsz]
	sub   al, al
	rep   stosb
	RET
bcdLdz	endp


;//////////////////////////////////////////////////////////////////////
;//	Name	bcdLd1
;//	Desc	Load +1 as a packed signed BCD value.
;//
;//
;//	Entry	Passed args
;//	Exit	Destination = +1. Acc undefined.

bcdLd1	proc
arg	dstBCD	:dataptr, \	; Addr of destination BCD
	dstsz	:@uint		; Byte size of dest.
@uses	es,rdi,rcx,rax
;.
	@cld
	@LES  rdi, [dstBCD]
	mov   rcx, [dstsz]
	mov   al, 01h
	stosb
	dec   rcx
	sub   al, al
	rep   stosb
	RET
bcdLd1	endp


;//////////////////////////////////////////////////////////////////////
;//	Name	bcdLd100
;//	Desc	Load +100 (decimal) as a packed signed BCD value.
;//
;//
;//	Entry	Passed args
;//	Exit	Destination = +100. Acc undefined.

bcdLd100 proc
arg	dstBCD	:dataptr, \	; Addr of destination BCD
	dstsz	:@uint		; Byte size of dest.
@uses	es,rdi,rcx,rax
;.
	@cld
	@LES  rdi, [dstBCD]
	mov   rcx, [dstsz]
	mov   rax, 0100h
        stosW
	dec   rcx
        dec   rcx
	rep   stosb
	RET
bcdLd100 endp

	END