        (* Sample Turbo Pascal DOS app using BCDASM routines *)
{$G+}   (* 80286 CPU *) (* Optional: $X+ use extended syntax *)

uses    BCD;

const
        BCDSZ = 10;
        BUFSZ = 256;
var
        bnum : array[1..BCDSZ] of byte; (* BCD variable goes here *)
        buf  : array[1..BUFSZ] of char; (* String output buffer   *)
        pbcd : pbyte;                   (* ^byte, from BCD.PAS    *)
        nstr : string;
        acc  : integer;
        slen : word;

begin
        nstr := '61728394506172839'#0;  (* Note trailing zero     *)
        pbcd := Addr(bnum);             (* Ptr to BCD variable    *)

        acc  := bcdA2p(pbcd, BCDSZ,     (* Convert nstr to BCD    *)
                   Addr(nstr[1]) );     (* Point past length byte *)
        acc  := bcdAdd(pbcd, pbcd, BCDSZ);  (* Add to self        *)
        acc  := bcdNeg(pbcd, BCDSZ);    (* Reverse sign           *)

                                        (* Convert BCD to Ascii   *)
        slen := bcdFmt(Addr(buf),BUFSZ, pbcd,BCDSZ,
                32,$ffff,$ffff,$ff, #$ff,#$ff,#$ff,#$ff);
        write('Hello from BCDASM: ');
        slen := WriteZStr(Addr(buf));   (* Display Ascii string   *)
        writeln;
        Halt(0);
end.