#ifndef BCD_H           /* BCDASM header file */
#define BCD_H           /* Requires 80186 CPU */

#ifndef WIN32
#define bcdapi __cdecl          /* bcd16?c.lib */
#else
#define bcdapi __stdcall        /* bcd32fs.lib */
#endif
#ifndef uint
typedef unsigned int    uint;
#endif
#ifndef byte
typedef unsigned char   byte;
#endif
typedef char            chrA;   /* ASCII/ANSI (one-byte char) */

/* Limits of packed BCD variables */
#define MIN_SIZEOF_BCD  4U
#define MAX_SIZEOF_BCD  ((uint)(~(MIN_SIZEOF_BCD-1)))
#define MAX_SIZEOF_XBCD ((uint)(MAX_SIZEOF_BCD >> 1))


#ifdef __cplusplus
extern "C" {
#endif

/* BCDASM function prototypes */
/* math */
void bcdapi bcdAbs     (byte *dst, uint sz);
int  bcdapi bcdNeg     (byte *dst, uint sz);
int  bcdapi bcdCmp     (byte *dst, byte *src, uint sz);
int  bcdapi bcdCmpz    (byte *dst, uint sz);
int  bcdapi bcdAdd     (byte *dst, byte *src, uint sz);
int  bcdapi bcdSub     (byte *dst, byte *src, uint sz);
void bcdapi bcdImul    (byte *xdst, byte *xsrc, uint sz);
int  bcdapi bcdIdiv    (byte *xdst, byte *xsrc, uint sz);
int  bcdapi bcdShr     (byte *dst, uint sz, uint count);
int  bcdapi bcdShl     (byte *dst, uint sz, uint count);
/* transfer */
void bcdapi bcdMov     (byte *dst, byte *src, uint sz);
void bcdapi bcdSwap    (byte *dst, byte *src, uint sz);
void bcdapi bcdLdz     (byte *dst, uint sz);
void bcdapi bcdLd1     (byte *dst, uint sz);
void bcdapi bcdLd100   (byte *dst, uint sz);
/* conversion */
void bcdapi bcdSx      (byte *xdst, byte *src, uint srcsz);
int  bcdapi bcdIsbcd   (byte *dst, uint sz);
int  bcdapi bcdA2p     (byte *dst, uint dstsz, chrA *pStr);
uint bcdapi bcdP2a     (chrA *pStr, byte *src, uint srcsz);
int  bcdapi bcdB2p     (byte *dst, uint dstsz, void *src, uint srcsz);
void bcdapi bcdP2b     (void *dst, uint dstsz, byte *src, uint srcsz);
void bcdapi bcdBe2le   (byte *dst, byte *src, uint srcsz);
void bcdapi bcdLe2be   (byte *dst, byte *src, uint srcsz);
int  bcdapi bcdU2p     (byte *dst, byte *usrc, uint srcsz);
void bcdapi bcdP2u     (byte *udst, byte *src, uint srcsz);
uint bcdapi bcdFmt     (chrA *pStr, uint strsz, byte *pBCD, uint sz,
                        uint width, uint numDec, uint prec, byte rtJust,
                        chrA signCh, chrA fillCh, chrA sepCh, chrA sepMCh);


/* BCDUU  (for unpacked unsigned BCDs) */
void bcdapi BCDUUmov   (byte *dst, byte *src, uint sz);
int  bcdapi BCDUUadd   (byte *dst, byte *src, uint sz);
int  bcdapi BCDUUsub   (byte *dst, byte *src, uint sz);
int  bcdapi BCDUUu2p   (byte *dst, byte *src, uint srcsz);
uint bcdapi BCDUUu2a   (chrA *pStr, byte *src, uint srcsz);
void bcdapi BCDUUmul   (byte *xdst, byte *xsrc, uint sz);


/* BIN2ASC */
uint bcdapi bin2asc    (chrA *pStr, byte *src, uint srcsz);
uint bcdapi HexN       (chrA *pStr, uint mval);


/* CONSOLIO */
int  bcdapi IsDevRedir (uint hDev);
byte bcdapi GetKey     (void);
uint bcdapi WriteZStr  (chrA *pStr);
uint bcdapi WriteNL    (void);

#ifdef __cplusplus
}
#endif

/*
 Function return values (void if not stated)
 Fnx         < 0        == 0        > 0
 bcdNeg    dst < 0    dst == 0    dst > 0
 bcdCmp    dst < src  dst == src  dst > src
 bcdCmpz   dst < 0    dst == 0    dst > 0
 bcdAdd    n/a        No carry    Carry
 bcdSub    n/a        No borrow   Borrow
 bcdIdiv   n/a        DivZ/Ovf    No error
 bcdShr    n/a        dst == 0    dst != 0
 bcdShl    n/a        dst == 0    dst != 0
 bcdIsbcd  n/a        Error       No error
 bcdA2p    n/a        Error       No error
 bcdP2a    n/a        n/a         String length
 bcdB2p    n/a        Error       No error
 bcdU2p    n/a        Error       No error
 bcdFmt    n/a        Error       String length
 -
 BCDUUadd  n/a        No carry    Carry
 BCDUUsub  n/a        No borrow   Borrow
 BCDUUu2p  n/a        Error       No error
 BCDUUu2a  n/a        n/a         String length
 -
 bin2asc   n/a        Error       String length
 HexN      n/a        n/a         String length
 -
 IsDevRedir Error     No          Yes
 GetKey    n/a        Ascii character
 WriteZStr n/a        No. of bytes written to stdout
 WriteNL   n/a        No. of bytes written to stdout
*/

#endif  /* BCD_H */