	title	X86BCD -- Copyright 1997, Morten Elling
	subttl	Display result and flags after BCD operations on AL

	.model	dos small
	.stack	0100h

;  This program outputs several tables to show the effect on
;  the AL and flags registers of the processor instructions
;  DAA, DAS, AAA, and AAS.
;  The contents of each table is determined by the state of
;  the carry and adjust flags as well as the contents of the
;  AL register before the BCD instruction is executed.
;
;  Assembly : tasm x86bcd
;  Link     : tlink /x x86bcd
;  Usage    : x86bcd.exe [> x86bcd.txt]


	BCDops equ <DAA,DAS,AAA,AAS>
	show_sf = 0		; En-/disable display of flags
	show_zf = 0
	show_af = 1
	show_pf = 0
	show_cf = 1
	SEPARATOR = '!';0B3h	; Column separator character
	EOS = 00h		; End-of-string marker


	.code
% irp op,BCDops 		; Define procedure for each op.
	op&_:			; Append underscore to op name
	op
	retn
	endm


	.const
test_start label byte
% irp op,BCDops 	; Define 4 tables for each BCD operation
	irp cf_,<0,1>			; Carry flag before op
	irp af_,<0,1>			; Adjust flag before op
	TEST_SIZE = $
	dw offset op&_			; Offset of procedure
	db (af_ shl 4) OR (cf_ shl 0)	; af+cf OR mask for flags
	; Table header
	db "&op   [ Before &op: AL=00h..0FFh, af=&af_ cf=&cf_."
	db "   After &op, AL and flags are: ]", EOS
	TEST_SIZE = ($-TEST_SIZE)
	endm
	endm
	endm
test_end label byte


; /////////////////////////////////////////////////////////////////////
;	Macros to handle simple buffered output

@InitBuf MACRO
	.data?
	BUF_SIZE = 1024 * 36
buf db	BUF_SIZE dup (?)	; Define output buffer
	.code
	lea   di, [buf]
	endm

@OutByte MACRO char		; Output a byte
	mov   byte ptr [di], char
	inc   di
	endm

@OutNL	MACRO			; Output a CR/LF pair
	@OutByte  0dh
	@OutByte  0ah
	endm

@OutStr MACRO offs		; Output an EOS-ended string
	local str1, str2
	push  si
	mov   si, offs
	jmp short str2
	str1:
	@OutByte al
	str2:
	mov   al, [si]
	inc   si
	cmp   al, EOS
	jnz   str1
	pop   si
	endm

@FlushBuf MACRO 		; Flush output buffer
	local ahead
	push  bx
	push  cx
	push  dx
	lea   dx, [buf]
	mov   cx, di
	sub   cx, dx
	jz    ahead
	mov   bx, 1		; Standard output
	mov   ah, 40h		; WriteHandle fnx
	int   21h
	mov   di, dx		; Reset ptr to buf start
	ahead:
	pop   dx
	pop   cx
	pop   bx
	endm

@FlushBufIfHigh MACRO
	local ahead
	cmp   di, offset buf + \
	      BUF_SIZE - BUF_SIZE shr 3
	jbe   ahead		; If above high water mark
	@FlushBuf		;   flush the output buffer
	ahead:
	endm


@OutFlag MACRO reg,fmask,token	; Output flag token or blank
	local ahead
	test  reg, fmask
	mov   al, ' '		;; Blank if flag not set
	jz    ahead
	mov   al, token
	ahead:
	@OutByte al
	endm


	.code

; /////////////////////////////////////////////////////////////////////
;	Display AL in hex, along with flags (AH)

opres	proc
	push  ax		; Save flags

	; Display AL in hex
	mov   ah, al
	shr   al, 1		; Get high nibble
	shr   al, 1
	shr   al, 1
	shr   al, 1
	add   al, 90h		; Convert to
	daa			;  hex Ascii
	adc   al, 40h		;   using Allison's
	daa			;    algorithm
	@OutByte al		; Display high nibble

	mov   al, ah
	and   al, 0Fh		; Get low nibble
	cmp   al, 0Ah		; Convert to hex Ascii
	sbb   al, 69h		;  using improved
	das			;   Allison's algorithm
	@OutByte al		; Display low nibble


	; Display flags
	pop   ax		; ah = arithmetic flags

	if show_sf
	@OutFlag ah,80h,'s'
	endif
	if show_zf
	@OutFlag ah,40h,'z'
	endif
	if show_af
	@OutFlag ah,10h,'a'
	endif
	if show_pf
	@OutFlag ah,04h,'p'
	endif
	if show_cf
	@OutFlag ah,01h,'c'
	endif

	ret
opres	endp


; /////////////////////////////////////////////////////////////////////

main	proc
	.startup

	@InitBuf		; di -> output buffer
	lea   si, [test_start]	; si -> test data

looptop:
	@OutNL			; New line
	lea   ax, [si+3]	; Display table header
	@OutStr ax
	@OutNL

	; Make a 16-by-16 table
	sub   bl, bl		; Zero counter
	mov   ch, 16		; 16 rows
row:	mov   cl, 16		; 16 columns
col:	mov   ah, [si+2]	; Get af and cf values
	sahf			; Store ah to flags
	mov   al, bl		; Copy counter to al
	call  word ptr [si]	; Perform the operation on al

	lahf			; ah = arithmetic flags
	call  opres		; Display result and flags
	@OutByte SEPARATOR	; Separate for readability

	inc   bl		; Step counter
	dec   cl		; Next row?
	jnz   col		; Not yet
	@OutNL			; New line
	@FlushBufIfHigh
	dec   ch		; Done with this table?
	jnz   row		; Not yet


	; Get ready for next loop
	@OutNL			; New line
	add   si, TEST_SIZE
	cmp   si, offset test_end
	jb    looptop

	@FlushBuf		; Flush output buffer

	.exit 0
main	endp

	END   main