REM James J. Eager     1-(407)-678-3145   Ver 1.00    8 Mar 1989
REM (C)opyright James J. Eager 1989
REM ------------------------------------------------------------------
REM The program requires the /E and /N compiler switches.  I recommend
REM the /D and /O switches also.
REM
REM Filenames may not be fully qualified file/path names.
REM
DIM CMD$(10),EM$(76)
REM load error messages into an array
CALL LOADERR(EM$())
ON ERROR GOTO PRTERR
PRINT "(C)opyright James J. Eager 1989  Release 1.00"
PRINT
PRINT "Call log extract program"
PRINT
REM calculate today's julian date
TODAY$ = DATE$
CALL GREGJUL ( TODAY$, JULYEAR%, JULDAY%)
IF JULDAY% = 0 THEN_
    END
CALL PARSE((COMMAND$),CMD$()," ","X")
REM did we get command line input?
REM force running in correct directory so rename will work later
CALL VALFILE (CMD$(1),"N","N","Y",RETCODE%):_
IF RETCODE% <> 0 THEN_
    PRINT "Invalid parameters entered - aborting":_
    PRINT:_
    PRINT "Parameters should be - CALLLOG <filename> #":_
    PRINT "Where <filename> is the name of the callers log file":_
    PRINT "and # is the number of days (from 1 to 365) to keep":_
    PRINT:_
    PRINT "No paths, directories, or device names are allowed in":_
    PRINT "the filename":_
    END
OLDFILE$ = CMD$(1)
OFFSET% = VAL(CMD$(2))
IF OFFSET% < 1 OR OFFSET% > 365 THEN_
    PRINT "Invalid parameters entered - aborting":_
    PRINT:_
    PRINT "Parameters should be - CALLLOG <filename> #":_
    PRINT "Where <filename> is the name of the callers log file":_
    PRINT "and # is the number of days (from 1 to 365) to keep":_
    PRINT:_
    PRINT "No paths, directories, or device names are allowed in":_
    PRINT "the filename":_
    END
PRINT "Keeping";OFFSET%;"day";
IF OFFSET% > 1 THEN_
    PRINT "s":_
ELSE_
    PRINT
PRINT
PRINT "This process will require some time"
PRINT "Please be patient..."
PRINT
OFFSET% = - OFFSET%
REM calculate earliest keep day
CALL CALCJUL (JULYEAR%, JULDAY%, OFFSET%)
TARGETYEAR% = JULYEAR%
TARGETDAY% = JULDAY%
REM open up files and lets go to work
OPEN CMD$(1) FOR RANDOM AS #1 LEN = 64
FIELD #1, 64 AS OLDLOG$
OPEN "WORKFILE.$$$" FOR RANDOM AS #2 LEN = 64
FIELD #2, 64 AS NEWLOG$
REM how long is the input file?
LASTREC% = LOF(1) / 64
J% = 1
REM ok loop for it
FOR I% = 1 TO LASTREC%
    GET #1,I%
    IF J% > 1 THEN_
        LSET NEWLOG$ = OLDLOG$:_
        PUT #2,J%:_
        J% = J% + 1
    IF J% = 1 THEN_
        CALL PARSE ((OLDLOG$),CMD$()," ","X"):_
        IF CMD$(1) = "SYSOP" THEN_
            TEMP$ = CMD$(4):_
        ELSE_
            TEMP$ = CMD$(5)
    IF J% = 1 THEN_
        CALL PARSE (TEMP$,CMD$(),",","X"):_
        CALL GREGJUL (CMD$(1), JULYEAR%, JULDAY%):_
REM ok now we have the date in this line, do we keep the line?
    IF J% = 1 THEN_
        IF JULYEAR% => TARGETYEAR% AND_
            JULDAY% => TARGETDAY% THEN_
            LSET NEWLOG$ = OLDLOG$:_
            PUT #2,J%:_
            J% = J% + 1
NEXT I%
REM found end of file now close out and quit
REM lets log ourselves in for posterity
LOGNOTE$ = DATE$ + " " + TIME$ + " Call log extract program - keeping"
LOGNOTE$ = LOGNOTE$ + STR$(-OFFSET%) + " day"
IF OFFSET% < -1 THEN _
    LOGNOTE$ = LOGNOTE$ + "s"
LSET NEWLOG$ = LOGNOTE$
REM for some reason the last 2 lines in the callers log are blank, so use
REM them over again
PUT #2,J% - 2
LOGNOTE$ = "(C)opyright James J. Eager 1989  Release 1.00"
LSET NEWLOG$ = LOGNOTE$
PUT#2,J% - 1
CLOSE #1
CLOSE #2
KILL OLDFILE$
NAME "WORKFILE.$$$" AS OLDFILE$
END
PRTERR:
REM error routine to print error messages in case of error
     CLS
     CLOSE
     PRINT "An error has been encountered"
     PRINT
     PRINT "The error code is ";ERR
     PRINT
     IF ERR < 76 THEN _
         PRINT "which means: ";EM$(ERR):_
     ELSE_
         PRINT "unknown error"
     PRINT
     IF ERDEV$<>"" THEN _
         PRINT "The device causing the error is: ";ERDEV$:_
         PRINT:_
         PRINT "The device error code is: ";ERDEV:_
         PRINT
     CLOSE
     END
RETURN
