;*************************************************************************
;* MCI.ASP  (C) 1987 DATASTORM TECHNOLOGIES, INC.                        *
;*                                                                       *
;* A sample ASPECT script file for logging onto MCI MAIL via tymnet.     *
;*                                                                       *
;* It checks for mail and sounds an alarm if mail is found.  Otherwise   *
;* it will log you off MCI MAIL.                                         *
;*                                                                       *
;*************************************************************************

ASSIGN S0 "874-2771"     ; enter your local TYMNET number here
ASSIGN S1 "uuuuu"        ; enter your USERID here
ASSIGN S2 "pppppppp"     ; enter your PASSWORD here

EMULATE ANSI               ; Select terminal emulation

WHEN "Press <RETURN>" "~^M"         ; Take care of paging
SET ATIME 0                         ; Reset alarm time

IF NOT LINKED                       ; If not called via Dial Dir
   CLEAR                            ; Clear the screen
   MESSAGE "Calling MCI MAIL via TYMNET"
   SET BAUD 1200                    ; Configure line settings
   SET PARITY EVEN
   SET DATABITS 7
   SET DUPLEX FULL
   MDIAL S0                         ; Dial TYMNET
ENDIF

PAUSE 3                             ; Wait a bit
TRANSMIT "A"                        ; Send the terminal ID
WAITFOR "please log in:" 30         ; Wait for prompt
TRANSMIT "mcimail^M"                ; Ask for MCIMAIL
WAITFOR "user name:"                ; Wait for prompt
TRANSMIT S1                         ; Send ID
TRANSMIT "^M"                       ; Send CR
WAITFOR "Password:"                 ; Waitfor prompt
TRANSMIT S2                         ; Send PASSWORD
TRANSMIT "^M"                       ; Send CR

WAITFOR "MCI Mail Version 4.0^M^J ^M^J    "   ; Wait for prompt

RGET S3                             ; Get mail message
WAITFOR "EXIT):"                    ; Wait for prompt

FIND S3 "no messages"               ; Check string for target
IF FOUND                            ; If no msgs
   TRANSMIT "exit^M"                ; Issue logout
   PAUSE 4                          ; Wait for logout
   HANGUP                           ; Hangup for TYMNET
   CLEAR                            ; Clear the screen
   MESSAGE "NO MESSAGES ON MCI"     ; Notify user
ELSE
   MESSAGE "YOU HAVE MESSAGES ON MCI"   ; Else notify user
   GOSUB ALERT                      ; Sound alarm
ENDIF

EXIT                                ; Exit script

; SUBROUTINE AREA

ALERT:       ; Subroutine ALERT sounds an alarm

SOUND 500 50
SOUND 400 50
SOUND 500 50
SOUND 400 50
SOUND 500 50
SOUND 400 50

RETURN

