/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tmltext.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TMultiLineText class.
*
* $Id: tmltext.cpp 1.2 1994/03/09 11:50:43 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tsttext.hpp"
#include "tfontmgr.hpp"
#include <string.h>

/*----------------------------- Implementation ----------------------------*/

TMultiLineText::TMultiLineText(const TRect& bounds,const char *text,
	ushort flags)
	: TStaticText(bounds,text,flags)
/****************************************************************************
*
* Function:		TMultiLineText::TMultiLineText
* Parameters:	bounds	- Bounding box for the text
*				text	- Pointer to the text to display
*				flags	- Static text creation flags
*
* Description:	Constructor for the TMultiLineText class. Note that the
*				text is _not_ copied onto the heap, but is simply
*				used as a reference. This is more efficient, but also
*				allows the text to be quickly set to another value by
*				pointing it somewhere else.
*
****************************************************************************/
{
	setText(text);
}

const char *TMultiLineText::setText(const char *t)
/****************************************************************************
*
* Function:		TMultiLineText::setText
* Parameters:	t	- New string for the text
* Returns:		Pointer to old text.
*
* Description:	Sets the text for the static text item, and also
*				re-computes the position to draw the text at.
*
****************************************************************************/
{
	const char *ret = text;
	text = t;

	// Set the current font and size, and obtain the fonts metrics

	metrics m;
	fontManager.useFont(fmSystemFont);
	MGL_getFontMetrics(&m);

	// Compute the location to draw the text at. First we need to work out
	// the number of lines of text that will be drawn.

	lines = countLines(t,size.x-1,(flags & sfWrap));

	int hjust = (flags & sfLeftJust ? LEFT_TEXT :
				(flags & sfRightJust ? RIGHT_TEXT : CENTER_TEXT));
	int vjust = (flags & sfTopJust ? TOP_TEXT :
				(flags & sfBottomJust ? BOTTOM_TEXT : CENTER_TEXT));
	tjust.setJustification(hjust,vjust);

	TRect r(bounds);
	r.moveTo(0,0);

	start.x = 	(hjust == LEFT_TEXT ? 	 r.left() :
				(hjust == CENTER_TEXT ? (r.left() + r.right())/2 :
										 r.right()-1));
	start.y =	(vjust == TOP_TEXT ? 	 r.top() :
				(vjust == CENTER_TEXT ? ((r.top() + r.bottom()
											- MGL_textHeight()*(lines-1))/2) :
										 r.bottom()-1
											- MGL_textHeight()*(lines-1)));
	repaint();
	return ret;
}

void TMultiLineText::draw(const TRect& clip)
/****************************************************************************
*
* Function:		TMultiLineText::draw
* Parameters:	clip	- Clipping rectangle for the view
*
* Description:	Draw's the static text item.
*
****************************************************************************/
{
	MGL_setClipRect(clip);				// Clip text to clip rect

	TextJust old;
	tjust.use();

	fontManager.useFont(fmSystemFont);
	MGL_setColor(getColor(23));

	// Loop around drawing each line of text, wrapping at the right edge
	// if necessary.

	char 	*startText = (char*)text,*p = startText;
	int 	x = start.x + bounds.left(),y = start.y + bounds.top();
	int		width = 0,height = MGL_textHeight();
	bool 	drawIt = false,wrap = (flags & sfWrap);
	char 	oldChar;

	while (*p) {
		if (*p == '\n' || *p == '\\' && *(p+1) == 'n') {
			drawIt = true;
			width = 0;
			}
		else {
			width += MGL_charWidth(*p);
			if (wrap && width >= size.x) {
				while (*p != ' ')
					p--;			// Back up to previous space character

				drawIt = true;
				width = 0;
				}
			}

		if (drawIt) {
			oldChar = *p;
			*p = 0;
			MGL_drawStrXY(x,y,startText);
			y += height;
			*p = oldChar;
			startText = p+1;
			if (*p == '\\' && *(p+1) == 'n')
				startText++;
			drawIt = false;
			}
		p++;
		}

	if (*startText != 0)
		MGL_drawStrXY(x,y,startText);

	old.use();
}
