/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tinputl.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TInputLine class. This class is used
*				to obtain a single line of text from the user.
*
* $Id: tinputl.hpp 1.2 1994/03/09 11:50:15 kjb Exp $
*
****************************************************************************/

#ifndef	__TINPUTL_HPP
#define	__TINPUTL_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

ushort const

	tlCursorVisible	= 0x0001,		// Cursor is visible
	tlOverwriteMode	= 0x0002,		// Key's overwrite the text
	tlDirty			= 0x0004;		// The input line is dirty (needs drawing)

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TInputLine class is used to obtain a single line of text from the
// user, up to a maximum specified length. Scrolling is supported if the
// line is too long to fit within the view. Note that the buffer passed
// to the input line routine will need to be large enough to store the
// edited text.
//
// Palette layout:
//		1 = Light border
//		2 = Dark border
//		3 = Interior
//		4 = Normal text
//		5 = Selected text
//		6 = Selection color
//		7 = Cursor color
//
// TInputLine's are intended to be inserted into TDialog's.
//---------------------------------------------------------------------------

class TInputLine : public TView {
protected:
	char 	*text;				// Text being edited
	short	maxLen;				// Maximum length for input line
	short	len;				// Current text length
	short	curPos;				// Current insertion position (index)
	short	curLoc;				// Current cursor location (coordinate)
	short	firstPos;			// Index of first displayed character
	short	selStart;			// Index of first selected character
	short	selEnd;				// Index of last selected character
	short	starty;				// Starting y coordinate for text
	short	scrollChars;		// Number of characters to scroll
	ushort	flags;				// Flags for the input line
	ushort  oldTicks;			// Old tick count
	static	ushort cursorRate;	// Rate of cursor flashing

			// Method to reposition to text within the window
			void repositionText();

			// Method to clear the highlight
			void clearHighlight();

			// Method to delete a number of characters from the text
			void deleteChars(short start,short count);

			// Method to insert a character into the text
			void insertChar(char ch);

			// Delete the selected characters
			bool deleteHighlight();

			// Method to find a character position given a coordinate
			short findPos(const TPoint& p);

			// Method to select the next left character
			void selectLeft(short count,ushort modifiers);

			// Method to select the next right character
			void selectRight(short count,ushort modifiers);

			// Method to repaint the display
			void repaint(const TRect& clip);

			// Method to refresh the display (calls repaint if necessary)
			void refresh();

			// Method to draw the cursor
			void drawCursor(bool visible);

public:
			// Constructor
			TInputLine(const TRect& bounds,int maxLen,
				const char *defaultText = NULL);

			// Virtual destructor
	virtual	~TInputLine();

			// Method to set the bounds for the input line
	virtual	void setBounds(const TRect& bounds);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase);

			// Method to draw the input line
	virtual	void draw(const TRect& clip);
	virtual	void redraw();

			// Method called when idle
	virtual	void idle();

			// Method to change the cursor
	virtual	cursor *getCursor(const TPoint& p);

			// Method to get the text from the input line
			const char *getText() const { return text; };

			// Method to set the text for the input line
			void setText(const char *text);

			// Method to set the cursor flash rate
			void setCursorRate(ushort rate)	{ cursorRate = rate; };
			ushort getCursorRate()			{ return cursorRate; };

			// Method to return a reference to the view's current palette
	virtual	TPalette& getPalette() const;
	};

#endif	// __TINPUTL_HPP
