/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tmouse.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the mouse class. This is a simple C++
*				wrapper class for the mouse module from the MegaToolbox.
*
* $Id: tmouse.hpp 1.2 1994/03/09 11:50:21 kjb Exp $
*
****************************************************************************/

#ifndef	__TMOUSE_HPP
#define	__TMOUSE_HPP

#ifndef	__MGRAPH_H
#include "mgraph.h"
#endif

#ifndef	__MOUSE_H
#include "mouse.h"
#endif

#ifndef	__TPOINT_HPP
#include "tpoint.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The following defines a simple C++ wrapper class for the mouse routines
// in the mouse module. All the routines can be called even if a mouse is
// not present, but some will probably return garbage.
//---------------------------------------------------------------------------

class TMouse {
private:
	short	buttons;			// Number of buttons on the mouse

public:
			TMouse();
			~TMouse();

			// Resume operation of mouse subsystem
			void resume()	{ MS_suspend; };

			// Suspend operation of mouse subsystem
			void suspend()	{ MS_resume; };

			// Determine if a mouse is present
			bool present()	{ return buttons != 0; };

			// Show/hide the mouse cursor
			void show()			{ MS_show(); };
			void hide()     	{ MS_hide(); };
			void obscure()		{ MS_obscure(); };
			void unobscure()	{ MS_unobscure(); };

			// Set the graphics cursor
			void setCursor(cursor *cursor)		{ MS_setCursor(cursor); };

			// Set the mouse speed and double speed
			void speed(int hratio,int vratio)	{ MS_speed(hratio,vratio); };
			void dblSpeed(int threshold)		{ MS_dblSpeed(threshold); };

			// Return the value of mouse motion counters
			void motion(TPoint& p)				{ MS_motion(&p.x,&p.y); };

			// Return the current mouse position
			void pos(TPoint& p)
				{ ms_status ms; MS_pos(&ms); p.x = ms.x; p.y = ms.y; };

			// Set the current mouse position
			void moveTo(const TPoint& p)
				{ MS_moveTo(p.x,p.y); };
	};

/*--------------------------- Global Variables ----------------------------*/

extern TMouse mouse;

#endif	// __TMOUSE_HPP
