/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tbutton.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TButton class. This class is the base
*				class for all buttons, and simply draws the solid button
*				and handles all the normal interaction.
*
* $Id: tbutton.hpp 1.2 1994/03/09 11:50:10 kjb Exp $
*
****************************************************************************/

#ifndef	__TBUTTON_HPP
#define	__TBUTTON_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

ushort const

// Button flags

	bfNormal		= 0x0000,		// Button is normal
	bfDefault		= 0x0001,		// Button is the default button
	bfLeftJust		= 0x0002,		// Button caption is left justified
	bfRightJust		= 0x0004,		// Button caption is right justified
	bfTopJust		= 0x0008,		// Button caption is top justtified
	bfBottomJust	= 0x0010,		// Button caption is bottom justified
	bfBroadcast		= 0x0020;		// Broadcast the command to owner view

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The following is the base class for all button types. It does not
// draw the button caption, but relies on subclasses of this class to draw
// and appropriate caption. The palette values here are suggested colors
// only for the captions. Naturally if the caption is a color bitmap, the
// colors will be different!
//
// Palette layout:
//		1 = Light border
//		2 = Dark border
//		3 = Normal interior
//		4 = Depressed interior
//		5 = Normal caption
//		6 = Focused caption
//		7 = Disabled caption
//		8 = Default border
//
// TButton's are intended to be inserted into TDialogs.
//---------------------------------------------------------------------------

class TButtonBase : public TView {
protected:
	bool	amDefault;			// True if button is currently the default
	ushort	command;			// Command to generate when pressed
	ushort	flags;				// Flags for this button
	ushort	borderWidth;		// Width of the border

			// Internal method to draw the button body
	virtual	void drawBody(const TRect& clip,bool depressed);

			// Internal routine to activate the button when pressed
			void activate();

public:
			// Constructor
			TButtonBase(const TRect& bounds,ushort command,ushort flags,
				ushort borderWidth = 3);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Method to draw the button in current state
	virtual	void draw(const TRect& clip);
	virtual	void redraw();

			// Method to set the command posted by the button
			void setCommand(ushort c)	{ command = c; };

			// Method to set a state flag
	virtual	void setState(ushort state,bool set);

			// Method to return a reference to the view's current palette
	virtual	TPalette& getPalette() const;

			// Method to make the button the default
			void setDefault(bool enable);
	};

//---------------------------------------------------------------------------
// The following class is used to represent a standard button, that
// contains text drawn within the bounds of the button.
//---------------------------------------------------------------------------

class TButton : public TButtonBase {
protected:
	char			*title;			// Text to display
	TPoint			start;			// Position to begin drawing title at
	TextJust		tjust;			// Text justification
	char			hotChar;		// Character code for hot character
	ushort			hotIndex;		// Index of hot character
	TPoint			hot1,hot2;		// Coordinates of hot character underscore

			// Internal method to draw the button body
	virtual	void drawBody(const TRect& clip,bool depressed);

public:
			// Constructor
			TButton(const TRect& bounds,const char *title,
				ushort command,ushort flags = bfNormal,ushort borderWidth = 3);

			// Destructor
	virtual	~TButton();

			// Method to set the bounds for the button
	virtual	void setBounds(const TRect& bounds);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Method to set the title for the button
	virtual	void setTitle(const char *t);
	};

#endif	// __TBUTTON_HPP
