/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: mvision.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	General header file for the class library.
*
* $Id: mvision.hpp 1.2 1994/03/09 11:50:10 kjb Exp $
*
****************************************************************************/

#ifndef	__MVISION_HPP
#define	__MVISION_HPP

#ifndef	__POINT_HPP
#include "point.hpp"
#endif

#ifndef	__RECT_HPP
#include "rect.hpp"
#endif

#ifndef	__MGRAPH_H
#include "mgraph.h"
#endif

/*------------------------------ Constants --------------------------------*/

const ushort

// Standard system color indices

	scBlack				= 0,		// System black
	scWhite				= 1,		// System white
	scLightGray			= 2,		// System light gray
	scDarkGray			= 3,		// System dark gray
	scBlue				= 4,		// System blue
	scJade				= 5,		// System jade
	scYellow			= 6,		// System yellow
	scLightYellow		= 7,		// System light yellow
	scUser				= 8,		// First user color index

//  Standard command codes

	cmValid         	= 0,		// Command to check if view is valid
	cmQuit          	= 1,		// Command to kill the program
	cmError         	= 2,		// Unsupported command message
	cmMenu          	= 3,		// Starts a keyboard menu selection
	cmClose         	= 4,		// Close the currently active window
	cmZoom          	= 5,		// Zoom the currently active window
	cmResize        	= 6,		// Resize the currently active window
	cmMinimise			= 7,		// Minimise the current window
	cmMaximise			= 8,		// Maximise the current window
	cmNext          	= 9,		// Move to next active window
	cmPrev          	= 10,		// Move to previous active window
	cmHelp          	= 11,		// Activate the help mechanism

//  TDialog standard commands

	cmOk            	= 12,		// The OK button was pressed
	cmCancel        	= 13,		// The Cancel button was pressed
	cmYes           	= 14,		// The Yes button was pressed
	cmNo            	= 15,		// The No button was pressed
	cmDefault       	= 16,		// Default button selection (enter key)

//  Standard application commands

	cmCut				= 21,		// Cut selected item to clipboard
	cmCopy				= 22,		// Copy selected item to clipboard
	cmPaste				= 23,		// Paste item from clipboard
	cmUndo				= 24,		// Undo last command
	cmRedo				= 25,		// Redo last command
	cmClear				= 26,		// Clear selected item

// TScrollBar messages

	cmScrollBarChanged  = 50,		// Scroll bar thumb has moved
	cmScrollBarClicked  = 51,		// Part of scroll bar was activated

// TListViewer messages

	cmListItemSelected	= 52,		// Item in list was selected
	cmListCursorChanged	= 53,		// Cursor in list was moved

// TFontManager error commands

	cmInvalidFont		= 256,		// Invalid font number used
	cmLowFontMem		= 257,		// Couldn't load font (no memory)
	cmBadFontFile		= 258,		// File loaded was not a font file
	cmFontNotFound		= 259,		// Font file was not found

// Standard system commands

	cmRestart			= 260,		// The application should re-start
	cmGrabModal			= 261,		// View has grabbed the modal view
	cmReleaseModal		= 262,		// View has released the model view
	cmReceivedFocus		= 263,		// View recieved the current focus
	cmReleasedFocus		= 264,		// View released the current focus
	cmCommandSetChanged	= 265,		// Command set for the view changed
	cmRecordHistory 	= 266,		// Views should record current history

// TButton messages

	cmGrabDefault		= 267,		// Button has become the default
	cmReleaseDefault	= 268,		// But is no longer the default

// Standard file dialog commands

	cmFileOpen			= 269,		// Open button was hit
	cmFileSave			= 270,		// Save button was hit

// Pre-defined help context numbers

	hcNoContext 		= 0;		// No help context relevant

/*---------------------- Macros and type definitions ----------------------*/

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// Class for manipulating text justifications.
//---------------------------------------------------------------------------

class TextJust {
protected:
	int		horiz_just;			// Horiztonal justification
	int		vert_just;			// Vertical justification

public:
			// Constructors
			TextJust()	{ save(); };

			TextJust(int hJust,int vJust)
				{ setJustification(hJust,vJust); };

			// Method to change the justification
			void setJustification(int hJust,int vJust)
				{ horiz_just = hJust; vert_just = vJust; };

			// Method to use the current settings
			void use()	{ MGL_setTextJustify(horiz_just,vert_just); };

			// Method to save the current settings
			void save()	{ MGL_getTextJustify(&horiz_just,&vert_just); };

			// Method to return the justifications
			int hjust()	{ return horiz_just; };
			int vjust()	{ return vert_just; };
	};

/*-------------------------- Global Variables -----------------------------*/

// Pre-defined cursor definitions

extern cursor	CHECK_CURSOR;
extern cursor	CROSS_CURSOR;
extern cursor	GLOVE_CURSOR;
extern cursor	IBEAM_CURSOR;
extern cursor	*_MVIS_currentCursor;
extern int		_MVIS_sysLineWidth;			// Default system line width
extern int		_MVIS_sysScrollBarWidth;	// Default scroll bar width

/*------------------------- Function Prototypes ---------------------------*/

class TView;

// Memory management routines

void majorConsumer();
void normalConsumer();
bool lowMemory();

// Miscellaneous stuff

TView *validView(TView *view);
TView *message(TView *view,ushort what,ushort command,void *info = NULL);
char *newStr(const char *str);
char *newHotStr(const char *str,char& hotChar,ushort& hotIndex);
int countLines(const char *msg,int maxWidth,bool wrap);
void beep(void);

/*--------------------------- Inline functions ----------------------------*/

#ifdef	PRECOMPILED_HEADERS

// Pre-compile all of the headers used by the library

#include "tpoint.hpp"
#include "trect.hpp"
#include "tevent.hpp"
#include "tkeys.hpp"
#include "tmouse.hpp"
#include "tpalette.hpp"
#include "tview.hpp"
#include "tgroup.hpp"
#include "tframe.hpp"
#include "twindow.hpp"
#include "tmenu.hpp"
#include "tmenubar.hpp"
#include "tbackgnd.hpp"
#include "tdesktop.hpp"
#include "tprogram.hpp"
#include "tbutton.hpp"
#include "tdialog.hpp"
#include "tsttext.hpp"
#include "tfontmgr.hpp"
#include "tinputl.hpp"
#include "tfiledlg.hpp"
#include "tlist.hpp"
#include "tscrollb.hpp"
#include "msgbox.hpp"

#endif	// PRECOMPILED_HEADERS

#endif	// __MVISION_HPP
