///////////////////////////////////////////////////////////////////////////
//                                                                       //
//            File: XOnOff.cpp                                           //
//            started on: 23/2/92                                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  This class submits to XON and XOFF requests and so is compatible     //
//  with some modems. Useful for software flow control, also...          //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                    by Ofer Laor (AKA LeucroTTA)                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "xonoff.h"; // XONOFF.

// this class is SERIAL_PORT compatible - but on transmit will submit to
// XONs and XOFFs.


// update flow_enabled.
//
void XONOFF::flow_check(void)
{
//    flow_enabled= TRUE;
}

XONOFF::XONOFF()
{
    flow_enabled= TRUE;
}

// returns whether current char should be discarded.
BOOLEAN XONOFF::flow_set(BYTE in_byte)
{
    if (in_byte== XON) {
       if (!flow_enabled) {
          flow_enabled= TRUE;
          do_send();
          return TRUE;
       }

       flow_enabled= TRUE;
    }
    else if (in_byte== XOFF) {
         flow_enabled= FALSE;
         return TRUE;
    }

    return FALSE;
}

