/*
 *                      ***************
 *                      * X R F 3 . C *
 *                      ***************
 *
 * Sorted cross reference listing routines. 'prtree' performs an
 * inorder traversal of the id tree, printing the references to'
 * each id while visiting that node.
 *
 * Version V1.3          9-May-80
 * Version V1.4		10-Jul-80 MM	Bummed code, added 80 col. support
 * Version V1.5          2-Dec-84 MC	Tweak for CI86 on Msdos Rainbow
 *                       7-Jan-85 MC	Remove case sensitive printing order
 */

#include <stdio.h>
#include "xrf.h"

/*
 * Inorder tree traversal.
 */

prtree(link)
struct idt *link;

   {
   if (link != NULL)
      {
      prtree(link->left);       /* Visit the left */
      prtrefs(link);            /* Print refs for this one */
      prtree(link->right);      /* Visit the right */
      }
   }

/*
 * List out a line of references.
 * Start new page if it gets full.
 */

lstrefs()
   {
   if(++linpg > MAXLIN)                 /* New page if necessary */
      newpage();
   fputs(scanbf, lst);                 /* Write out the string */
   fputs("\n", lst);
   }

/*
 * Print id and references.
 * Share scan buffer for printout.
 * Use newpag.
 *
 * The ref line number field width is hard-wired into the format statement.
 * Trouble is, #define's don't (and shouldn't!) substitute into strings,
 * like formats.
 *
 * Current values are 5 char field (RSIZE) and rperline ref's per line.
 *
 * The node is now positioned in the tree in case non-sensitive order.
 * This means that in the final list mixed, upper & lower case symbols
 * appear togethor instead of being separated in the collating sequence.
 *
 * The id (*kp) now comes as <KEYactualNNNNNNNN> from XRF0.C where:-
 *		              KEY                is the symbol as lower case
 *                                                  length CPS characters.
 *                               actual          is the symbol as she appears
 *                                                  length CPS characters.
 *			               NNNNNNNN  is the program name
 *                                                  length 8 chars
 *
 */

prtrefs(link)
struct idt *link;

   {
   register struct ref *r;              /* Ref chain pointer */
   register char *p,*kp;                /* Fast scan buffer pointer */
   register int j;                      /* Counts refs printed on a line */
   register int i = 0;                  /* work counter */
   char *strcpy();                      /* cpystr returns char pointer */
   char keyname[9];                     /* program name for this symbol */
   r = link->first;                     /* r --> head of ref chain */
   p = scanbf;                          /* p --> start of scan buffer */
   j = 0;                               /* Init refs-per-line */
   kp = link->keyp + CPS + CPS;		/* init pname ptr */
   strcpy(keyname,kp);			/* Start with the program name */
   *kp = '\0';				/* then terminate ID string */
   kp = link->keyp + CPS;		/* reinit id string ptr */
   if(strcmp(kp,lastsym)){              /* if symbol change ... */
       strcpy(p, kp);                       /* ... then the id string */
       p += strlen(kp);
       strcpy(lastsym,kp);                  /* save as previous */
       }
   while(p < &scanbf[CPS])              /* Pad with blanks */
         *p++ = ' ';
   *p++ = ':';                          /* Followed by a separator */
   if(conflg){				/* Followed by progname    */
	for(i=0;i<8;*p++=keyname[i++]);
	*p++ = ' ';                          /* Followed by a space */
	}
   do
      {                                 /* List Reference line numbers */
      if(j >= rperline){                /* If this line is full */
         *p = '\0';                     /* Terminate with null */
         lstrefs();                     /* Write it out */
         j = 0;                         /* Reset refs-on-line count */
         for(p=scanbf;p<&scanbf[CPS];*p++ =' '); /*Reset buffer ptr*/
         *p++ = ':';                    /* plus a separator */
         if(conflg){				/* Followed by progname    */
            for(i=0;i<8;*p++=keyname[i++]);
            *p++ = ' ';                          /* Followed by a space */
            }
         }
      j++;
      sprintf(p,"%5d", r->lno);         /* Insert reference into buffer */
      p += RSIZE;                       /* Update buffer pointer */
      r = r->next;                      /* On down the chain */
      }
   while(r != NULL);                    /* Until the end */
   *p = '\0';                           /* Terminate with null */
   lstrefs();                           /* Write the line out */
   }
