;*************************************************************************
;* PURSUIT.ASP  (C) 1987 DATASTORM TECHNOLOGIES, INC.                    *
;*                                                                       *
;* This script file is used to dial PC Pursuit numbers.  It Demonstrates *
;* menu building, branching on user input, etc.  Please note that only   *
;* one PC Pursuit city (Atlanta) is implemented in this demo.            *
;*                                                                       *
;* A color monitor is assumed.                                           *
;*                                                                       *
;* String variables are used extensively here.  Their uses are:          *
;*                                                                       *
;* S0 - holds user input for SWITCHing                                   *
;* S1 - holds PCP city name                                              *
;* S2 - holds PCP city area code                                         *
;* S3 - holds final destination name                                     *
;* S4 - holds final destination phone number                             *
;* S5 - holds user input for SWITCHing                                   *
;* S6 - you must set to modem dial command and local TELENET number      *
;* S7 - you must set to apporpriate baud rate (3 or 12)                  *
;* S8 - you must set to your PCP user id                                 *
;* S9 - you must set to your PCP password                                *
;*                                                                       *
;*************************************************************************

; Customization area - you need to change these for your setup

   ASSIGN S9 "12"               ; Enter the baudrate to use here, 3 or 12
   ASSIGN S8 "xxxxxxx"          ; Enter the ID to be used here
   ASSIGN S7 "xxxxxxxx"         ; Enter the PASSWORD to be used here
   ASSIGN S6 "ATDTxxx-xxxx^M"   ; Enter dial cmd and local telenet # here

   SET CR CR                    ; make sure no extra LF's in menus
   CUROFF                       ; turn off the cursor
   CLEAR 2                      ; clear the screen

; Build the first menu

   BOX 1 23 21 55 31            ; draw the box
   ATSAY  2 26 30 "PC PURSUIT AVAILABLE CITIES"
   ATSAY  3 23 31 "Ķ"
   ATSAY  4 30 30 " 1- ATLANTA"
   ATSAY  5 30 30 " 2- BOSTON"
   ATSAY  6 30 30 " 3- DALLAS"
   ATSAY  7 30 30 " 4- DENVER"
   ATSAY  8 30 30 " 5- DETROIT"
   ATSAY  9 30 30 " 6- HOUSTON"
   ATSAY 10 30 30 " 7- LOS ANGELES"
   ATSAY 11 30 30 " 8- NEWARK"
   ATSAY 12 30 30 " 9- NEW YORK"
   ATSAY 13 30 30 "10- PHILADELPHIA"
   ATSAY 14 30 30 "11- SAN FRANCISCO"
   ATSAY 15 30 30 "12- SEATTLE"
   ATSAY 16 30 30 "13- WASHINGTON, DC"
   ATSAY 17 30 30 " 0- EXIT"
   ATSAY 18 23 31 "Ķ"
   ATSAY 19 25 30 "ENTER THE # OF THE CITY OF"
   ATSAY 20 25 30 "YOUR CHOICE:"

L1:                             ; label for use by default case

   ATGET 20 38 113 2 S0         ; get the user's response

   SWITCH S0                    ; switch on choice

      CASE "0"                  ; EXIT this script
         CLEAR                  ; clear the screen
         MESSAGE "PC Pursuit script ended."
         CURON                  ; turn the cursor on.
         TERMINAL               ; EXIT script and enter terminal mode
      ENDCASE

      CASE "1"                  ; chose ATLANTA
         ASSIGN S1 "ATLANTA"    ; save the city name
         ASSIGN S2 "404"        ; save the area code
         GOSUB ATLANTA          ; go get number to dial
      ENDCASE

      DEFAULT                   ; all other cases
         LOCATE 22,24
         SOUND 220 20           ; error noise
         LOCATE 22,24
         MESSAGE "Not yet implemented in this demo"
         LOCATE 22,24
         PAUSE 2
         MESSAGE "                                "
         GOTO L1
      ENDCASE
   ENDSWITCH

;
; Ok, call the local TELENET number first.  This is an example of
; redialing without using the DIAL or Alt-R commands
;

   CLEAR                        ; ready to call TELENET
   SET PARITY EVEN              ; set parms for TELENET
   SET DATABITS 7
   MESSAGE "DIALING PCP"        ; let em know whats happening
   LOCATE 0,12
   MESSAGE S1                   ; include city in message

L2:                             ; label for busy TELENET

   TRANSMIT S6                  ; call local Telenet
   WAITFOR "CONNECT" 15         ; give it 15 seconds to answer

   IF NOT WAITFOR               ; it didn't connect, assume busy
      CLEAR                     ; example of redialing without Alt-R
      HANGUP
      MESSAGE "PCP TELENET IS BUSY.  REDIALING..."
      GOTO L2
   ENDIF

;
; Ok, made it to local telenet number, now call the remote PCP city
; Notice that we redial at this point as well
;

   PAUSE 2
   TRANSMIT "^m^m"              ; Get Telenet's attention
   WAITFOR "="                  ; Wait for 'TERMINAL=' prompt
   TRANSMIT "D1^M"              ; Enter terminal type
   WAITFOR "@"                  ; Wait for Telenet prompt

L3:                             ; label for busy remote PCP city
   TRANSMIT "C DIAL"
   TRANSMIT S2                  ; area code
   TRANSMIT "/"
   TRANSMIT S9                  ; BAUD RATE
   TRANSMIT ","
   TRANSMIT S8                  ; ID
   TRANSMIT "^M"                ; cr

   WAITFOR "="                  ; Wait for 'PASSWORD=' prompt

   TRANSMIT S7                  ; Enter password
   TRANSMIT "^M"                ; cr

   RGET S5                      ; Get the CR echoed from our TRANSMIT
   RGET S5                      ; Get the CR that precedes PCP messages
   RGET S5                      ; Get the actual message
   PAUSE 1                      ; Display it briefly

   FIND S5 "CONNECT"            ; Look for connection

   IF NOT FOUND                 ; No connection
      CLEAR
      MESSAGE "THE REMOTE PCP IS BUSY.  REDIALING..." S1
      LOCATE 1 0
      GOTO L3
   ENDIF

;
; Ok, made it to the remote PCP city.  Display appropriate message
; then call the actual destination, again using a redial
;

   CLEAR
   MESSAGE "CONNECTED TO PCP"
   LOCATE 0,17
   MESSAGE S1
   LOCATE 1,0
   MESSAGE "DIALING"
   LOCATE 1,8
   MESSAGE S3

L4:                             ; label for busy number

   LOCATE 2 0
   TRANSMIT "ATZ^M"             ; Wake up remote modem
   WAITFOR "OK"                 ; Wait for 'OK' prompt

   TRANSMIT "ATDT"
   TRANSMIT S4                  ; THE NUMBER
   TRANSMIT "^M"                ; CR

   RGET S0                      ; Get CR echoed from our TRANSMIT
   RGET S0 80 40                ; Get CR that precedes PCP messages
   RGET S0                      ; Get the real message
   PAUSE 2

   FIND S0 "BUSY"               ; was it busy?
   IF FOUND
      CLEAR
      MESSAGE "BUSY.  REDIALING..." S3
      GOTO L4
   ENDIF

   FIND S0 "CONNECT"            ; did it connect?
   IF FOUND
      SET PARITY NONE           ; Switch to N/8/1 for BBS work
      SET DATABITS 8
      CLEAR
      MESSAGE "CONNECTED TO"
      LOCATE 0,13
      MESSAGE S3
      LOCATE 1,0
      MESSAGE "LOGON PRECEEDING"
   ELSE                         ; not busy or connect, assume error
      CLEAR
      MESSAGE "NO CONNECT OR BUSY. REDIALING"
      GOTO L4
   ENDIF

   ALARM 2                      ; sound alarm for 2 seconds
   EXIT                         ; we made it!



;********************************************************************
;
; SUBROUTINES START HERE
;
;********************************************************************

ATLANTA:

   CLEAR
   BOX 5 25 18 53 31
   ATSAY  5 29 30 " ATLANTA BBS NUMBERS "
   ATSAY  7 29 30 "1- ALTGATE"
   ATSAY  8 29 30 "2- Flagship Express"
   ATSAY  9 29 30 "3- BYTE Connection"
   ATSAY 10 29 30 "4- Microstuf BBS"
   ATSAY 11 29 30 "5- Software Link BBS"
   ATSAY 12 29 30 "6- PC-Exchange BBS"
   ATSAY 13 29 30 "M- Manual Dial"
   ATSAY 15 25 31 "Ķ"
   ATSAY 16 27 30 "ENTER THE # OF THE BBS OF"
   ATSAY 17 27 30 "YOUR CHOICE:"

ATL1:

   ATGET 17 40 113 1 S5

   SWITCH S5

      CASE "1"
         ASSIGN S3 "ATLGATE"            ; save the BBS name
         ASSIGN S4 "9281876"            ; save the number
      ENDCASE

      CASE "2"
         ASSIGN S3 "Flagship Express"
         ASSIGN S4 "9344515"
      ENDCASE

      CASE "3"
         ASSIGN S3 "BYTE Connection"
         ASSIGN S4 "9410159"
      ENDCASE

      CASE "4"
         ASSIGN S3 "Microstuf_BBS"
         ASSIGN S4 "9988048"
      ENDCASE

      CASE "5"
         ASSIGN S3 "Software Link"
         ASSIGN S4 "9986737"
      ENDCASE

      CASE "6"
         ASSIGN S3 "PC-Exchange BBS"
         ASSIGN S4 "9776686"
      ENDCASE

      CASE "M"
         CLEAR
         LOCATE 5,20
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 5,36
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE

      DEFAULT
         MESSAGE "^G"
         LOCATE 17,40
         GOTO ATL1
      ENDCASE

   ENDSWITCH
RETURN

;************* End of Subroutines **********************************
