;*************************************************************************
;* HOST.ASP  (C) 1987 DATASTORM TECHNOLOGIES, INC.                       *
;*                                                                       *
;* A sample ASPECT script file for PROCOMM PLUS to illustrate the use    *
;* of various ASPECT commands (and provide a way to consistently and     *
;* easily invoke HOST mode).                                             *
;*                                                                       *
;*************************************************************************

goto begin

;
;   Frequently called subroutines should be placed at the beginning of
;   an ASPECT file for maximum efficiency.
;

;****************************************;
;* statbox:  Fill in the status window. *;
;****************************************;
statbox:
   fatsay 8  35 15 "%-30s" s5
   fatsay 9  35 15 "%-30s" s4
   if zero n3
      atsay 12 35 15  "Immediate"
   else
      atoi s3 n0
      fatsay 12 35 15 "%s:%02d     " s2 n0
   endif
   if not zero n1
      atsay 13 35 15  "Enabled "
   else
      atsay 13 35 15  "Disabled"
   endif
   if zero n2
      atsay 14 35 15  "Just exit  "
   else
      atsay 14 35 15  "Exit to DOS"
   endif
return

;***********************************;
;* begin:  Logical starting place. *;
;***********************************;
begin:
gosub init                             ; You should go customize 'init'
gosub mainmenu                         ; display the main menu
top:                                   ; We come here after each key
   gosub statbox                       ; alsways show the stat box
   assign s1 "Which one ?                                "
   atsay 20  7 79 s1
   locate 20 19
   curon
   keyget s1
   switch s1
      case "A"
         help
         endcase
      case "Q"
         goto done
         endcase
      case "S"
         gosub setime
         endcase
      case "B"
         goto beginhst
         endcase
      case "V"
         dir "*.*"
         endcase
      case "D"
         gosub setdl
         endcase
      case "H"
         gosub help
         endcase
      case "U"
         gosub setul
         endcase
      case "L"
         atsay 20  7 79  "Press Enter and then Alt-P"
         locate 20 37
         get s1 0
         help
         endcase
      case "C"                         ; toggle call back flag
         if zero n1
            inc n1
         else
            dec n1
         endif
         endcase
      case "E"                         ; toggle quit all flag
         if zero n2
            inc n2
         else
            dec n2
         endif
         endcase
      default
         endcase
   endswitch
   goto top
;end main loop

done:
  clear
  exit
;********* end of main routine *********;


;*************************************;
;* beginhst:  Executes HOST command. *;
;*************************************;
beginhst:
   if not zero n3                      ; if delay is on, suspend
      clear 0
      atoi s3 n0
      fatsay 20 15 14 "Suspended until:  %s:%02d        (ESC to abort)" s2 n0
      suspend until s2 s3
   endif
   clear
   host
   if not zero n1
      goto callback
   endif
   if zero n2
      exit
   else
      quit
   endif


;************************************;
;* chk_range: verify numeric entry  *;
;* input:      n0 - value to verify *;
;*             n8 - lower limit     *;
;*             n9 - upper limit     *;
;*             (n8  n9 !!)         *;
;* output:     global 'SUCCESS' set *;
;*             if:  n8  n0  n9.   *;
;*             reset otherwise.     *;
;************************************;
chk_range:
   assign s0 "!"                       ; (n0 is in the range)
   strcmp s0 "!"                       ; set success to true
   if LT n0 n8
      goto chk_no
   endif
   if GT n0 n9
      goto chk_no
   endif
   return                              ; and return
chk_no:
   strcmp s0 "?"                       ; set success to false
   return                              ; and return


;************************************;
;* setime:  set suspend until time. *;
;************************************;
setime:
   assign s1 "What hour (00-23, <CR> for immediate) ?     "
   atsay 20  7 79 s1
   atget 20 47 78 2 s1
   strcpy s2 s1
   strcat s1 "Z"
   strcmp s1 "Z"
   if success                          ; if Enter, then
      init n3 0                        ; turn off delay flag
      return                           ; and exit
   endif
   atoi s2 n0                          ; else verify that entry
   init n8 1                           ; is from 0
   init n9 23                          ; to 23
   gosub chk_range                     ; using function: chk_range
   if not success
      sound 440 50
      pause 2
      goto setime
   endif                               ; else we have a starting time
   assign s1 "What min. (00-59, <CR> for 00) ?            "
   atsay 20  7 79 s1
   atget 20 47 78 2 s1
   strcpy s3 s1
   strcat s1 "Z"
   strcmp s1 "Z"
   if not success                      ; if not default, verify entry
      atoi s3 n0
      init n8 0                           ; is from 0
      init n9 59                          ; to 23
      gosub chk_range                     ; using function: chk_range
      if not success
         sound 440 50
         pause 2
         goto setime
      endif                               ; else we have a starting time
   else
      strcpy s3 "00"
   endif
   init n3 1                           ; turn on delay flag

return

;************************************;
;* help: display help screen.       *;
;************************************;
help:
   box  4,30, 17,67  31
   atsay  6   34  30   "No help is currently available"
   atsay  8   34  30   "       (Press any key)"
   keyget s0
;
;  Restore the status window
;
   box  4,30, 17,67  7
   atsay  6   38  112  " - Current settings - "
   atsay  7   30 7   ""
   atsay  8   30 7   "  "
   atsay  9   30 7   "  "
   atsay  10  30 7   "  "
   atsay  12  30 7   "  "
   atsay  13  30 7   "  "
   atsay  14  30 7   "  "
   atsay  15  30 7   ""
   atsay  10 35 15    "(See status line)"
return

;************************************;
;* callback:                        *;
;************************************;
callback:
   transmit "Enter phone number: "
   rget s1 25
   transmit "^M^MIs this correct: "
   transmit s1
   transmit " (Y/N/Q)?"
   rget  s0 1
   switch s0
      case "Q"
         goto quitcb
         endcase
      case "Y"
         init n0 5                     ; number of redial attempts
         goto havenum
         endcase
      default
         goto callback
         endcase
   endswitch

havenum:
   transmit "^MAfter I disconnect, verify that your modem will answer^M"
   pause 3
   hangup
tryagain
   pause 2
   mdial s1
   pause 2
   if not connected
      dec n0
      if LT n0 5
         goto tryagain
      else
         goto begin
      endif
   endif
   terminal

quitcb:
   transmit "^Mreturning to host mode"
   goto begin
return

;************************************;
;* setul: set upload directory.     *;
;************************************;
setul:
   gosub getdir
   if success
      strcpy s4 s1
      set dldir s4
      chdir s5
   endif
return

;************************************;
;* setdl: set download directory.   *;
;************************************;
setdl:
   gosub getdir
   if success
      strcpy s5 s1
   endif
return
blankmsg:
   assign s0 " "                          ; restore msg line
   fatsay 20 7 79  "%60s" s0
return

;****************************************;
;* getdir: general getdir routine.      *;
;* input:  none                         *;
;* output:                              *;
;*     prompts user for directory name. *;
;*     if valid entry, then             *;
;*        SUCCESS = true and s1 = dir.  *;
;*        (current dir changed to dir.) *;
;*     else (invalid entry)             *;
;*        SUCCESS = false.              *;
;****************************************;
getdir:
atsay 20  7 79  "Directory: "
atget 20 19 78 30 s1                   ; dir. is in s1
gosub blankmsg                         ; restore msg line
strcpy s0 s1                           ; work with copy in s0
strcat s0 "Z"
strcmp s0 "Z"                          ; is it null string?
if success                             ; if so,
   strcmp s0 "a"                       ;   set success to false
   return                              ;   and return
endif
strcpy s0 s1                           ; something's there, restore s0
strcat s0 "\$HOSTASP.BAT"              ; and let's see if we can
fopeno s0 BINARY                       ; open a temporary file in dir.
if success                             ; if so,
   chdir s1                            ;    change to dir.
   fcloseo                             ;    close temporary file
   dos    "ERASE $HOSTASP.BAT>NUL"     ;    and erase temp. file
else                                   ; otherwise
   atsay 20 7 79 "Invalid directory: " ;    say it was bad
   pause 1
endif
return


;************************************;
;* mainmenu:  paint the main menu.  *;
;************************************;
mainmenu:
   clear
   box 0 2 22 70 79

;        row col attr
   atsay  2    6  78  "- PREPARING TO ENTER HOST MODE -"
   atsay  4    7  78  "B"
   atsay  4    8  79  "egin HOST mode"
   atsay  5    7  78  "Q"
   atsay  5    8  79  "uit"

   atsay  7    7  78  "-=>  Setup <=-"
   atsay  8    7  78  "D"
   atsay  8    8  79  "ownload directory    "
   atsay  9    7  78  "U"
   atsay  9    8  79  "pload   directory    "
   atsay  10   7  78  "L"
   atsay  10   8  79  "ine settings      "

   atsay  11   7  78  "-=> Options <=-"
   atsay  12   7  78  "S"
   atsay  12   8  79  "tarting time      "
   atsay  13   7  78  "C"
   atsay  13   8  79  "all back (toggle)    "
   atsay  14   7  78  "E"
   atsay  14   8  79  "xit type (toggle)    "
   atsay  15   7  78  "-=>  Extra <=-"
   atsay  16   7  78  "V"
   atsay  16   8  79  "iew download dir."
   atsay  17   7  78  "A"
   atsay  17   8  79  "lt key function"
   atsay  18   7  78  "H"
   atsay  18   8  79  "elp"

   box  4,30, 17,67  7
   atsay  6   38  112  " - Current settings - "
   atsay  7   30 7   ""
   atsay  8   30 7   "  "
   atsay  9   30 7   "  "
   atsay  10  30 7   "  "
   atsay  12  30 7   "  "
   atsay  13  30 7   "  "
   atsay  14  30 7   "  "
   atsay  15  30 7   ""
   atsay  10 35 15    "(See status line)"

return ;from main menu


;************************************;
;* init:  Initialization code.      *;
;************************************;
init:
;n0 general purpose numeric var
init n1 0    ;callback enable flag  0=false, 1=enable call backs
init n2 0    ;quit all flag. 0=false, 1=quit script AND PROCOMM PLUS
init n3 0    ;delay flag. 0=false, 1=start host at specified time
;n7, n8, n9 reserved

;s0 s1 general purpose string
;s2 s2 is start hour.
;s3 s3 is start min.
assign s4 "c:\bbs\upld"   ;default upload directory
assign s5 "c:\bbs"        ;default download directory

set dldir s4
chdir s5
emulate vt102 ;adds remote script execution capability if superuser aborts
              ; and enabled in setup
return
