



          MicroPro Standard Library                                       pr


          NAME
               pr - print file

          SYNOPSIS
               pr [ option ] ... [ file ] ...

          DESCRIPTION
               Pr produces a printed listing of one or  more  files.    The
               output is separated into pages headed by a date, the name of
               the  file  or a specified header,  and the page number.   If
               there are no file arguments, pr prints its standard input.

               Options apply to all following files but may  be  reset  be-
               tween files:

               /n   Produce n-column output.

               /pn  Begin printing with page n.

               /h   Take the next argument as a page header.

               /wn  Take  the  width of the page to be n characters instead
                    of the default 80.

               /f   Use formfeeds instead of newlines to separate pages.  A
                    formfeed is assumed to use up two blank  lines  at  the
                    top  of a page.   (Thus this option does not affect the
                    effective page length.)

               /ln  Take the length of the page to be n  lines  instead  of
                    the default 66.

               /t   Do  not  print  the 5-line header or the 5-line trailer
                    normally supplied for each page.

               /sc  Separate columns by the single character c  instead  of
                    by the appropriate amount of white space.   A missing c
                    is taken to be a tab.

               /m   Print all files simultaneously, each in one column.

               /Tn  Take the width of a tab character to be  n  instead  of
                    the default 8.

               Note the following differences between UNIX pr(1) and PC-DOS
               pr:

               .    The  switch character may be changed from `/' to `-' by
                    the documented methods.

               .    The option structure  follows  the  conventions  estab-
                    lished  by  AT&T for UNIX command options,  enforced by
                    the use of the getopt() function.  Options that require

          December 5, 1986                                            Page 1
                             MicroPro Business Confidential




          MicroPro Standard Library                                       pr

                    arguments (such as /l) may have white space between the
                    option and the argument or not.  Several options may be
                    concatenated behind a single `/' with  no  white  space
                    separating them.

               .    More  than  9  columns  are not supported,  or 15 files
                    printed simultaneously.

               .    The UNIX "+n" option is replaced by "/pn".

          EXAMPLE

                    pr /t /m filea fileb filec

               will print out the three files simultaneously,  each in  one
          column, without headers.

          AUTHOR

               Mojo Jones, mojo@micropro.UUCP



































          December 5, 1986                                            Page 2
                             MicroPro Business Confidential
