/* ALIGN LABEL - A Program to Align Mailing Labels */
/* Version 1.0 by Richard Conn */

/* Usage: labalign [-L#] [-C#] [-B#] [-N#] */

/* Instructions:
   This program outputs a series of alignment labels to
   help the user align the mailing labels in his printer.

   Available options are:
   	-L# - set the number of text lines per label (default 8)
   	-C# - set the number of columns per label (default 40)
   	-B# - set the number of blank lines between labels (default 1)
   	-N# - set the number of labels to print (default 5)
*/

#include <stdio.h>

#define NLINES 8
#define NCOLS 40
#define NBLANKS 1
#define NLABS 5

int lines = NLINES;
int columns = NCOLS;
int blanks = NBLANKS;
int labs = NLABS;

main (argc, argv)
int argc;
char *argv[];
{
        int i;
        int opterr = 0;

	for (i=1; i<argc; i++) {
		if (*argv[i] == '-') {
			switch (argv[i][1]) {
				case 'b' :
				case 'B' : blanks = atoi (&argv[i][2]);
					   if (blanks == 0) opterr = 1;
					   break;
				case 'c' :
				case 'C' : columns = atoi (&argv[i][2]);
					   if (columns == 0) opterr = 1;
					   break;
				case 'l' :
				case 'L' : lines = atoi (&argv[i][2]);
					   if (lines == 0) opterr = 1;
					   break;
				case 'n' :
				case 'N' : labs = atoi (&argv[i][2]);
					   if (labs == 0) opterr = 1;
					   break;
				default  : opterr = 1;
					   break;
			}
		}
	}
	if (opterr) {
		printf (" Syntax: %s [-L#] [-C#] [-B#] [-N#]\n", argv[0]);
		printf ("   Where:\n");
		printf ("     -L# is the number of text lines/label (def %d)\n",
			NLINES);
		printf ("     -C# is the number of columns/label (def %d)\n",
			NCOLS);
		printf ("     -B# is the number of blank lines between labels (def %d)\n",
			NBLANKS);
		printf ("     -N# is the number of labels to print (def %d)\n",
			NLABS);
	} else align();
}

/* Print an alignment series */
align ()
{
	int i, j, k;

	for (k=0; k<labs; k++) {
		for (i=0; i<lines; i++) {
			for (j=0; j<columns; j++)
				if (j % 5) printf ("-");
				else printf ("|");
			printf ("\n");
		}
		for (j=0; j<blanks; j++) printf ("\n");
	}
}
