/*
 *			L A S E R . C 
 *
 * $Revision:   1.7  $
 *
 * $Log:   E:\usr\ljsetup\vcs\laser.c_v  $
 * 
 *    Rev 1.7   13 Aug 1986 10:18:26   bbechtel
 * Corrected to work under MS-DOS with Microsoft 3.0
 * 
 *    Rev 1.6   13 Aug 1986  9:51:04   bbechtel
 * Initial revision.
 * Revision 1.5  86/07/14  17:51:09  ron
 * Prepared for distribution
 * 
 * Revision 1.4  86/07/14  16:34:19  ron
 * Cleaned up code, generally made more human readable.
 * 
 * Revision 1.3  86/07/14  15:05:31  ron
 * Basically re-wrote the whole damned thing to support all, well most
 * of the LaserJet features that are available.  Instead of simply supporting
 * those that were originally used.  The program now supports all of the
 * HP font cartridges with most of the attributes available...
 * 
 * Revision 1.2  86/07/14  09:46:30  ron
 * Added distinctive RCS header
 * 
 */
#ifndef lint
static char RCSid[] = "@(#)$Header:   E:\usr\ljsetup\vcs\laser.c_v   1.7   13 Aug 1986 10:18:26   bbechtel  $";
#endif

#include <stdio.h>


#define	LPRCMD "/usr/bin/lp 2>/dev/null 2>&1"

/*  If your system can handle it... */
/* #define BIGHELPTEXT		/* ... mine can't */

#define USAGE() fprintf (stderr, ">>>> Type 'laser -H' to display a help screen.\n")

HELP () {
    fprintf (stderr, "Laser Command Options:\n");
    fprintf (stderr, "  c	--	Character Set\n");
    fprintf (stderr, "    (1)  Roman-8        (2)  USASCII  (3)  Roman Ext. (4)  Danish/Norwegian\n");
    fprintf (stderr, "    (5)  United Kingdom (6)  French   (7)  German     (8)  Italian\n");
    fprintf (stderr, "    (9)  Swedish       (10)  Spanish (11)  Legal     (12)  Linedraw\n");
    fprintf (stderr, "   (13)  Math8         (14)  Math8a  (15)  Math8b    (16)  Math7\n");
    fprintf (stderr, "   (17)  PiFont        (18)  PiFonta\n");
    fprintf (stderr, "  o	--	Orientation (Portrait or Landscape, P or L)\n");
    fprintf (stderr, "  t	--	Typeface\n");
    fprintf (stderr, "    (1)  Courier        (2)  Line Printer   (3)  Helvetica\n");
    fprintf (stderr, "    (4)  Times Roman    (5)  Prestige Elite (6)  Gothic\n");
    fprintf (stderr, "  h	--	Point Size (character height)\n");
    fprintf (stderr, "    (1)  7 Pt. (2)  8 Pt. (3)  8.5 Pt. (4)  10 Pt. (5)  12 Pt. (6)  14.4 Pt.\n");
    fprintf (stderr, "  p	--	Pitch\n");
    fprintf (stderr, "    (1)  10 cpi (2)  12 cpi (3)  16.66 cpi\n");
    fprintf (stderr, "  s	--	Spacing (Proportional or Fixed, P or F)\n");
    fprintf (stderr, "  l	--	Lines per inch (1, 2, 3, 4, 6, 8, 12, 16, 24)\n");
    fprintf (stderr, "  i	--	Italic\n");
    fprintf (stderr, "  b	--	Bold\n");
    fprintf (stderr, "  O	--	Offset from left edge (number of spaces)\n");
    fprintf (stderr, "  P	--	Page Step (number of extra lines)\n");
    fprintf (stderr, "  F	--	Forms Length (number of lines in form)\n");
    fprintf (stderr, "  w	--	Send results to standard output\n");
}

static char *Symbols[] =
{
    "\033(8U",			/* Roman-8 */
    "\033(0U",			/* USASCII */
    "\033(0E",			/* Roman Ext. */
    "\033(0D",			/* Danish/Norwegian */
    "\033(1E",			/* United Kingdom */
    "\033(0F",			/* French */
    "\033(0G",			/* German */
    "\033(0I",			/* Italian */
    "\033(0S",			/* Swedish/Finnish */
    "\033(1S",			/* Spanish */
    "\033(1U",			/* Legal */
    "\033(0B",			/* Line Draw */
    "\033(8M",			/* Math8 */
    "\033(0Q",			/* Math8a */
    "\033(1Q",			/* Math8b */
    "\033(0M",			/* Math7 */
    "\033(15U",			/* PiFont */
    "\033(2Q",			/* PiFonta */
    0
};

static char *Spacing[] =
{
    "\033(s1P",			/* Proportional */
    "\033(s0P",			/* Fixed */
    0
};

static char *Type[] =
{				/* Yes I know their not in order... */
    "\033(s3T",			/* Courier (default) */
    "\033(s0T",			/* Line Printer */
    "\033(s4T",			/* Helvetica */
    "\033(s5T",			/* Times Roman */
    "\033(s8T",			/* Prestige Elite */
    "\033(s6T",			/* Gothic */
    "\033(s1T",			/* Pica */
    "\033(s7T",			/* Script */
    "\033(s9T",			/* Caslon */
    "\033(s10T",		/* Orator */
    0
};

static char *Orientation[] =
{
    "\033&l0O",			/* Portrait */
    "\033&l1O",			/* Landscape */
    0
};

static char *Point[] =
{
    "\033(s7V",			/* 7 Pt. */
    "\033(s8V",			/* 8 Pt. */
    "\033(s8.5V",		/* 8.5 Pt. */
    "\033(s10V",		/* 10 Pt. */
    "\033(s12V",		/* 12 Pt. */
    "\033(s14.4V",		/* 14.4 Pt */
    0
};

static char *Pitch[] =
{
    "\033(s10H",		/* 10 CPI */
    "\033(s12H",		/* 12 CPI */
    "\033(s16.6H",		/* 16.66 CPI */
    "",				/* no pitch for proportional spacing */
    0
};

static char *Lpi[] =
{
    "\033&l7.27c66F",		/* 66 lines per page with 1/2 at top and
				   bot */
    "\033&l1d66F",		/* 1 lpi */
    "\033&l2d66F",		/* 2 lpi */
    "\033&l3d66F",		/* 3 lpi */
    "\033&l4d66F",		/* 4 lpi */
    "\033&l6d66F",		/* 6 lpi */
    "\033&l8d66F",		/* 8 lpi */
    "\033&l12d66F",		/* 12 lpi */
    "\033&l16d66F",		/* 16 lpi */
    "\033&l24d66F",		/* 24 lpi */
    0
};

static char *Italic = "\033(s1S";

static char *Bold = "\033(s3B";

#define		CTRL(c)		('c' & 037)

/*
 *  Defaults
 */

int     sym = 1;
int     type = 0;
int     spc = 1;
int     orient = 0;
int     ps = 3;
int     ptch = 0;
int     lpi = 0;
int     offset = 0;
int     stdoutput = 0;
int     pagestep = 8;
int     forms = 66;
int     italic = 0;
int     bold = 0;
int     Debug = 0;

main (argc, argv)
int     argc;
char   *argv[];
{
    FILE * fp, *fopen ();
    extern char *optarg;
    extern int  optind;
    int     i,
            c,
            errflg = 0;

    while ((c = getopt (argc, argv, "c:o:t:h:l:s:p:O:P:F:biHwd")) != EOF) {
	switch (c) {
	    case 'd': 
		++Debug;
		break;

	    case 'l': 
		lpi = atoi (optarg);
		switch (lpi) {
		    case 1: 
		    case 2: 
		    case 3: 
		    case 4: 
		    case 6: 
		    case 8: 
		    case 12: 
		    case 16: 
		    case 24: 
			if (Debug)
			    fprintf (stderr, "lpi = %d, ", lpi);
			break;
		    default: 
			printf ("Lines Per Inch values must be one of 1, 2, 3, 4, 6, 8, 12, 16, or 24.\n");
			USAGE ();
			exit (1);
		}
		break;
	    case 'o': 
		if (*optarg == 'p' || *optarg == 'P')
		    orient = 0;
		else
		    if (*optarg == 'l' || *optarg == 'L')
			orient = 1;
		    else {
			printf ("Orientation must be specified as either 'P' or 'L'.\n");
			USAGE ();
			exit (1);
		    }
		if (Debug)
		    fprintf (stderr, "orientation -> %c, ", *optarg);
		break;

	    case 't': 
		type = atoi (optarg);
		--type;
		if (type < 0 || type > 10) {
		    printf ("Typeface selection must be in the range of 1 (one) to 6 (six).\n");
		    USAGE ();
		    exit (1);
		}
	    /* Set up some defaults in case none of these are chosen
	       explicitly */
		switch (type) {
		    case 0: 
			sym = orient = ptch = 0;
			spc = 1;
			ps = 4;
			break;
		    case 1: 
			sym = spc = 1;
			orient = 0;
			ps = ptch = 2;
			break;
		    case 2: 
			sym = spc = 0;
			orient = 1;
			ps = ptch = 3;
			break;
		    case 3: 
			sym = spc = orient = 0;
			ps = 4;
			ptch = 1;
			break;
		    case 4: 
			sym = orient = 0;
			spc = 1;
			ps = 3;
			ptch = 1;
			break;
		    case 5: 
			sym = orient = 0;
			spc = 1;
			ps = 4;
			ptch = 1;
			break;
		    case 6: 
			sym = orient = 0;
			spc = ptch = 1;
			ps = 4;
			break;
		}
		if (Debug)
		    fprintf (stderr, "typeface = %d, ", type);
		break;

	    case 's': 
		if (*optarg == 'P' || *optarg == 'p') {
		    spc = 0;
		    ptch = 3;
		}
		else
		    if (*optarg == 'F' || *optarg == 'f')
			spc = 1;
		    else {
			printf ("Spacing must be specified as either 'P' or 'F'\n");
			USAGE ();
			exit (1);
		    }
		if (Debug)
		    fprintf (stderr, "spacing -> %c, ", *optarg);
		break;

	    case 'h': 
		ps = atoi (optarg);
		--ps;
		if (ps < 0 || ps > 6) {
		    printf ("Point size must be specified within the range of 1 (one) to 6 (six)\n");
		    USAGE ();
		    exit (1);
		}
		if (Debug)
		    fprintf (stderr, "point size = %d, ", ps);
		break;

	    case 'p': 
		ptch = atoi (optarg);
		--ptch;
		if (ptch < 0 || ptch > 3) {
		    printf ("Pitch must be specified within the range of 1 (one) to 6 (six).\n");
		    USAGE ();
		    exit (1);
		}
		if (Debug)
		    fprintf (stderr, "pitch = %d, ", ptch);
		break;

	    case 'c': 		/* Symbol Set selection */
		sym = atoi (optarg);
		--sym;
		if (sym < 0 || sym > 18) {
		    printf ("Character set selection must be between the range of 1 (one) and 18 (eighteen).\n");
		    USAGE ();
		    exit (1);
		}
		if (Debug)
		    fprintf (stderr, "symbol set = %d, ", sym);
		break;

	    case 'O': 		/* Offset from left margin */
		offset = atoi (optarg);
		if (offset < 0 || offset > 80) {
		    printf ("Offset value must be specified between the range of 0 (zero) and 80 (eighty).\n");
		    USAGE ();
		    exit (1);
		}
		if (Debug)
		    fprintf (stderr, "offset = %d, ", offset);
		break;

	    case 'P': 
		pagestep = atoi (optarg);
		if (pagestep < 0 || pagestep > 66) {
		    printf ("Page Step value must be specified between the range of 1 (one) and 66 (sixty six).\n");
		    USAGE ();
		    exit (1);
		}
		if (Debug)
		    fprintf (stderr, "page step = %d, ", pagestep);
		break;

	    case 'F': 
		forms = atoi (optarg);
		if (forms < 0) {
		    printf ("Forms value must be greater than 0 (zero).\n");
		    USAGE ();
		    exit (1);
		}
		if (Debug)
		    fprintf (stderr, "forms = %d, ", forms);
		break;

	    case 'i': 
		italic++;
		if (Debug)
		    fprintf (stderr, "italics set, ");
		break;

	    case 'b': 
		bold++;
		if (Debug)
		    fprintf (stderr, "bold set, ");
		break;

	    case 'w': 		/* Standard Output */
		if (Debug)
		    fprintf (stderr, "results to stdout, ");
		stdoutput++;
		break;

	    case 'H': 
		HELP ();
		exit (1);

	    default: 
		errflg++;
		break;
	}
    }

    if (errflg) {
	fprintf (stderr, "laser [ - {options} ] [ files ] ... \n");
	USAGE ();
	exit (1);
    }

    if (Debug)
	fprintf (stderr, "\b \n");

    if (argc == optind)
	sendjob (stdin);
    else
	for (; optind < argc; optind++)
	    if ((fp = fopen (argv[optind], "r")) == NULL) {
		fprintf (stderr, "laser: can't open %s\n", argv[optind]);
		exit (1);
	    }
	    else {
		sendjob (fp);
		fclose (fp);
	    }
    exit (0);
}

sendjob (fp)
FILE * fp;
{
    FILE * pp, *open ();
    int     pg = pagestep,
            c,
            lines;

    if (!stdoutput) {
	if ((pp = fopen ("LPT2", "w")) == NULL) {
	    fprintf (stderr, "laser: cannot pipe to line printer device.\n");
	    exit (1);
	}
    }
    else
	pp = stdout;

 /* reset		perf skip ON */
    fprintf (pp, "\033E%s%s%s%s%s%s%s\033&l1L\r",
	    Symbols[sym],
	    Spacing[spc],
	    Orientation[orient],
	    Type[type],
	    Point[ps],
	    Lpi[lpi],
	    Pitch[ptch]);

    if (forms != 66)
	fprintf (pp, "\033&l%dF\r", forms);

    if (bold)
	fprintf (pp, "%s\r", Bold);

    if (italic)
	fprintf (pp, "%s\r", Italic);

    if (offset)
	fprintf (pp, "\033&a%dL\r", offset);

    while ((c = getc (fp)) != EOF) {
	if (c == CTRL (l)) {
	    while (lines < forms) {
		putc ('\n', pp);
		lines++;
	    }
	    continue;		/* eat the ^L char */
	}
	if (c == CTRL (j)) {
	    if (lines == forms) {
		while (pg-- > 0)
		    putc ('\n', pp);
		lines = 0;
		continue;
	    }
	    else
		lines++;
	}
	putc (c, pp);
    }
    fprintf (pp, "\033E");	/* reset the printer to default settings 
				*/
    fclose (pp);
}
