/****************************************************************************
*
*						  Protected Mode Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: biosptr.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:  Test program to check the ability to manipulate the
*				BIOS data area from protected mode using the PMODE
*				library. Compile and link with the appropriate command
*				line for your DOS extender.
*
*				Functions tested:	PMODE_getBIOSPointer()
*									PMODE_getLong()
*									PMODE_getByte()
*									PMODE_getWord()
*
* $Id: biosptr.c 1.1 1994/03/10 09:05:43 kjb release $
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "pmode.h"

/* Macros to obtain values from the BIOS data area */

#define TICKS()		PMODE_getLong(bios, 0x6C)
#define KB_STAT		PMODE_getByte(bios, 0x17)
#define KB_HEAD		PMODE_getWord(bios, 0x1A)
#define KB_TAIL		PMODE_getWord(bios, 0x1C)

/* Macros for working with the keyboard buffer */

#define KB_HIT()	(KB_HEAD != KB_TAIL)
#define CTRL()		(KB_STAT & 4)
#define SHIFT()		(KB_STAT & 2)
#define ESC			0x1B

/* Pointer to BIOS data area */

void *bios = NULL;

void main(void)
{
	int	c,done = 0;

	printf("Program running in ");
	switch (_PMODE_modeType) {
		case PMODE_realMode:
			printf("real mode.\n\n");
			break;
		case PMODE_286:
			printf("16 bit protected mode.\n\n");
			break;
		case PMODE_386:
			printf("32 bit protected mode.\n\n");
			break;
        }

	if ((bios = PMODE_getBIOSPointer()) == NULL) {
		printf("Could not obtain pointer to BIOS data area!!\n");
		exit(1);
		}

	printf("Hit any key to test, Ctrl-Shift-Esc to quit\n");
	while (!done) {
		if (KB_HIT()) {
			c = getch();
            printf("TIME=%-8lX ST=%02X CHAR=%02X ", TICKS(), KB_STAT, c);
            if (c == 0)
				printf("%02X", getch());		/* Extended character */
            printf("\n");
			if ((c == ESC) && SHIFT() && CTRL())/* Ctrl-Shift-Esc */
                break;
			}
		}
}
