/****************************************************************************
*
*								Buildrsp
*
*					Copyright (C) 1991 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: buildrsp.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	MS DOS
*
* Description:	Program to build a response file from a file containing
*				a simple list of files. The format of the response file
*				is specified using a standard printf style format string.
*
* $Id: buildrsp.c 1.1 92/04/18 17:25:52 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log:	buildrsp.c $
* Revision 1.1  92/04/18  17:25:52  kjb
* Initial revision
* 
****************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <process.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include "getopt.h"

#define	MAX_FILES		200			/* 200 files maximum				*/

/*------------------------- Global variables ------------------------------*/

char	*rcsid = "$Id: buildrsp.c 1.1 92/04/18 17:25:52 kjb Exp $";
char	*filenames[MAX_FILES];
int		suppressamp = false;
int		msc = false;

/* Open a file returning true if successful */

int openfile(FILE **in,char *filename,char *mode)
{
	if( (*in = fopen(filename,mode) ) == NULL) {
		return false;	/* Open failed									*/
		}
	else
		return true;	/* Open was successful							*/
}

void readfilenames(char *name,char *filenames[],int *numfiles)
/****************************************************************************
*
* Function:		readfilenames
* Parameters:	name		- Name of file to read filenames from
*				filenames[]	- Array to place filenames in
*				numfiles	- Number of filenames read
*
* Description:	Reads the names of the files to translate from the
*				specified file 'name'. We expect each file name to we
*				a whole word on the line and ignore all whitespace.
*
****************************************************************************/
{
	char	buf[MAXPATH];
	FILE	*f;

	if (!openfile(&f,name,"rt")) {
		printf("Unable to open the file: %s\n",name);
		exit(1);
		}

	*numfiles = 0;
	while (!feof(f) && (fscanf(f," %s ",buf) == 1)) {
		filenames[*numfiles] = strdup(buf);
		(*numfiles)++;
		}

	fclose(f);
}

void help(void)
{
	printf("Usage: buildrsp [-wms] <filelist>\n\n");
	printf("where <filelist> is the name of a file containing the\n");
	printf("filenames to build the librarian response file with.\n");
	printf("The response file is sent to the standard output device.\n");
	printf("\n");
	printf("Options are:\n");
	printf("\n");
	printf("    -m   Generate Microsoft C LIB style response file\n");
	printf("    -w   Generate Watcom WLIB style response file\n");
	printf("    -s   Generate Symantec C++ LIB style response file\n");
	printf("\nBy default a Borland TLIB style response file is generated.\n");
	exit(1);
}

int main(int argc,char *argv[])
{
	int		i,numfiles,option;
	char	*argument;

	do {
		option = getopt(argc,argv,"mw",&argument);
		switch(option) {
			case 'w':
				suppressamp = true;
				break;
			case 'm':
				msc = true;
				break;
			case INVALID:
				help();
			}
		} while (option != ALLDONE && option != PARAMETER);

	if ((argc - nextargv) < 1)
		help();

	readfilenames(argv[nextargv],filenames,&numfiles);

	/* Build each line of the response file */

	for (i = 0; i < numfiles-1; i++)
		printf("-+%s%s\n",filenames[i], (suppressamp ? "" : " &"));
	printf("-+%s%s\n",filenames[i], (msc ? " &" : ""));
	if (msc) printf(",,\n");

	return 0;
}
