/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tmodesel.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TModeSelector class. This class is used
*				to represent a dialog box for selecting a valid new
*				video mode to put the system into.
*
* $Id: tmodesel.hpp 1.2 1994/03/09 11:50:21 kjb Exp $
*
****************************************************************************/

#ifndef	__TMODESEL_HPP
#define	__TMODESEL_HPP

#ifndef	__TDIALOG_HPP
#include "tdialog.hpp"
#endif

#ifndef	__TINPUTL_HPP
#include "tinputl.hpp"
#endif

#ifndef	__TLIST_HPP
#include "tlist.hpp"
#endif

#ifndef	__ARRAY_HPP
#include "array.hpp"
#endif

#ifndef	__STR_HPP
#include "str.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TModeSelector class is designed to provide a standard mechanism for
// allowing users to select a new video mode.
//
// Returns cmOK if a valid selection was made.
//---------------------------------------------------------------------------

class TModeSelector : public TDialog {
protected:
	int				driver;			// Video drive number
	int				mode;			// Current video mode number
	TList			*modeList;		// List of video modes
	ISArray<DynStr>	modenames;		// Array of video mode names

	static const char *setText;		// Text for standard buttons
	static const char *helpText;
	static const char *cancelText;
	static const char *modeListText;

public:
			// Constructor
			TModeSelector(const char *title,int driver,int mode,
				int *validModes);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase);

			// Method to obtain the selected video mode
			int getMode();
	};

#endif	// __TFILEDLG_HPP
