/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tbackgnd.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TBackGround class. This class is used
*				to draw a patterned background in the system background
*				colors.
*
* $Id: tbackgnd.hpp 1.2 1994/03/09 11:50:10 kjb Exp $
*
****************************************************************************/

#ifndef	__TBACKGND_HPP
#define	__TBACKGND_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TBackGround class is a view that draws a patterned backGround in
// the system background colors.
//
// Palette layout:
//		1 = Background color for pattern
//		2 = Foreground color for pattern
//---------------------------------------------------------------------------

class TBackGround : public TView {
protected:
	int		fillStyle;			// Style for filling background
	pattern	pat;				// Pattern to draw with

public:
			// Constructor
			TBackGround(const TRect& bounds,int fillStyle = SOLID_PATTERN,
				const pattern& pat = SOLID_FILL);

			// Method to draw the background
	virtual	void draw(const TRect& clip);

			// Method to return a reference to the view's current palette
	virtual	TPalette& getPalette() const;
	};

#endif	// __TBACKGND_HPP
