/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: message.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Implementation for the message function.
*
* $Id: message.cpp 1.2 1994/03/09 11:50:25 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tview.hpp"

/*----------------------------- Implementation ----------------------------*/

TView *message(TView *view,ushort what,ushort command,void *info)
/****************************************************************************
*
* Function:		message
* Parameters:	view	- View to send the message to
*				what	- Event code for the message
*				command	- Command code for the message
*				info	- Pointer to optional information for the message
* Returns:		Pointer to the view that handled the message, NULL if none
*
* Description:
*
****************************************************************************/
{
	if (view == NULL)
		return NULL;

	TEvent event;
	event.what = what;
	event.message.command = command;
	event.message.infoPtr = info;

	view->setupOwnerViewport();
	view->handleEvent(event);
	view->resetViewport();

	// If the event was handled, the what field will be set to evNothing,
	// so return a pointer to the view that handled the message.

	if (event.what == evNothing)
		return (TView*)event.message.infoPtr;
	return NULL;
}
