/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tdialog.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TDialog class. This class is used
*				to group together a number of views into a pop-up box
*				used for displaying messages etc.
*
* $Id: tdialog.hpp 1.2 1994/03/09 11:50:10 kjb Exp $
*
****************************************************************************/

#ifndef	__TDIALOG_HPP
#define	__TDIALOG_HPP

#ifndef	__TWINDOW_HPP
#include "twindow.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

const ushort

// Default TDialog flags

	wfNormalDialog	= wfMoveable | wfClose | wfFramed;

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TDialog class is a type of window that is designed to contain
// buttons and other interactive views. By default TDialogs are moveable
// but not-resizeable and modal.
//
// Palette layout:
//		1 = Light Border
//		2 = Dark Border
//		3 = Active frame
//		4 = Active solid frame
//		5 = Passive frame
//		6 = Background color
//		7 = Active title bar
//		8 = Passive title bar
//		9 = Active title text
//	   10 = Passive title text
//     11 = Title bar icons
//	   12 = Scroll bar interior
//	   13 = Active scroll bar arrow
//	   14 = Inactive scroll bar arrow
//	   15 = Unselected scroll bar interior
//	   16 = Selected scroll bar interior
//	   17 = Normal button interior
//	   18 = Depressed button interior
//	   19 = Normal button caption
//	   20 = Selected button caption
//	   21 = Disabled button caption
//	   22 = Default border
//     23 = Static Text
//	   24 = Input line interior
//	   25 = Input line normal text
//	   26 = Input line selected text
//     27 = Input line selection color
//	   28 = Input line cursor color
//	   29 = List interior
//	   30 = List normal cell color
//	   31 = List selected cell color
//	   32 = List highlight color
//	   33 = List cursor color
//---------------------------------------------------------------------------

class TDialog : public TWindow {
public:
			// Constructor
			TDialog(const TRect& bounds,const char *title = NULL,
				ushort flags = wfNormalDialog);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Virtual to determine if the dialog has finished
	virtual	bool valid(ushort command);

			// Method to return a reference to the view's current palette
	virtual	TPalette& getPalette() const;
	};

#endif	// __TDIALOG_HPP
