/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: twindow.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TWindow class. This class is used
*				to represent pop-up windows used by TDialogs etc.
*
* $Id: twindow.hpp 1.2 1994/03/09 11:50:25 kjb Exp $
*
****************************************************************************/

#ifndef	__TWINDOW_HPP
#define	__TWINDOW_HPP

#ifndef	__TGROUP_HPP
#include "tgroup.hpp"
#endif

#ifndef	__TFRAME_HPP
#include "tframe.hpp"
#endif

#ifndef	__TTITLEB_HPP
#include "ttitleb.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

const ushort

// TWindow creation flag masks

	wfMoveable		= 0x0001,		// Window can be moved
	wfResizeable	= 0x0002,		// Window can be resized
	wfClose			= 0x0004,		// Window has a close icon and menu
	wfMinimise		= 0x0008,		// Window has a minimise icon
	wfMaximise		= 0x0010,		// Window has a maximise icon
	wfFramed		= 0x0020,		// Window has a 3d frame
	wfSolidFramed	= 0x0040,		// Window has a solid frame
	wfLeftJust		= 0x0080,		// Window title is left justified
	wfRightJust		= 0x0100,		// Window title is right justified
	wfTopJust		= 0x0200,		// Window title is top justified
	wfBottomJust	= 0x0400,		// Window title is bottom justified
	wfNormal		= wfMoveable | wfResizeable | wfClose | wfMaximise
						| wfMinimise | wfFramed;

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TWindowInit class is used to create hold a pointer to a frame
// creation routine. We need this to solve the problem with virtual function
// calls from within a superclasse's constructor.
//---------------------------------------------------------------------------

class TWindowInit {
protected:
	TFrame		*(*createFrame)(const TRect& bounds,ushort);
	TTitleBar	*(*createTitleBar)(const TRect& bounds,const char *title,
					ushort flags);

public:
			TWindowInit(TFrame *(*createFrame)(const TRect&,ushort),
						TTitleBar *(*createTitleBar)(const TRect&,
							const char*,ushort))
				: createFrame(createFrame),
				  createTitleBar(createTitleBar) {};
	};

//---------------------------------------------------------------------------
// The TWindow class is special group that maintains a collection of views
// in a moveable and re-sizeable window. TWindow's are modeless by default.
//
// The frame and title for the window are within the main window bounds.
//
// Palette layout:
//		1 = Light Border
//		2 = Dark Border
//		3 = Active frame
//		4 = Active solid frame
//		5 = Passive frame
//		6 = Background color
//		7 = Active title bar
//		8 = Passive title bar
//		9 = Active title text
//	   10 = Passive title text
//     11 = Title bar icons
//	   12 = Scroll bar interior
//	   13 = Active scroll bar arrow
//	   14 = Inactive scroll bar arrow
//	   15 = Unselected scroll bar interior
//	   16 = Selected scroll bar interior
//---------------------------------------------------------------------------

class TWindow : public TGroup, public virtual TWindowInit {
protected:
	TFrame		*frame;				// Frame for the window
	TTitleBar	*titleBar;			// Title bar for the window
	short		number;				// Number of this window
	ushort		flags;				// Flags the type of window

			// Method to draw the window's background
	virtual	void drawBackground(const TRect& clip);

public:
			// Constructor
			TWindow(const TRect& bounds,const char *title = NULL,
				ushort flags = wfNormal);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Method to set the bounds of the view
	virtual	void setBounds(const TRect& bounds);

			// Method to move the window to another location
	virtual	void moveTo(int x,int y);

			// Method to return a reference to the view's current palette
	virtual	TPalette& getPalette() const;

			// Default creation routines for windows
	static	TFrame* initFrame(const TRect& bounds,ushort flags);
	static	TTitleBar *initTitleBar(const TRect& bounds,const char *title,
				ushort flags);
	};

#endif	// __TWINDOW_HPP

