/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tmenubar.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TMenuBar class. This class is used
*				to implement the standard menu bar mechanism for the
*				library.
*
* $Id: tmenubar.hpp 1.2 1994/03/09 11:50:15 kjb Exp $
*
****************************************************************************/

#ifndef	__TMENUBAR_HPP
#define	__TMENUBAR_HPP

#ifndef	__TMENU_HPP
#include "tmenu.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TMenuBar class is the class used to implement the standard horizontal
// menu bar mechanism for the library. The palette is the same as the
// standard TMenu palette.
//---------------------------------------------------------------------------

class TMenuBar : public TMenu {
protected:
			// Method to draw a menu item
	virtual	void drawItem(int index);

			// Method to compute the bounding rectangle for an item
	virtual	TRect& setItemBounds(int index,const TPoint& start);

			// Method to find which menu item was hit
			int findSelected(TPoint& where);

public:
			// Constructor
			TMenuBar(const TRect& bounds)
				: TMenu(bounds) {};

			// Virtual to execute the menu tracking the mouse etc
	virtual	ushort execute();

			// Virtual to draw the menu
	virtual	void draw(const TRect& clip);

			// Method to complete the menu bar definition
	virtual	void doneDefinition();
	};

#endif	// __TMENUBAR_HPP
