/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tframe.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TFrame class. This class is used
*				to represent the frame around the outside of dialog
*				boxes and windows.
*
* $Id: tframe.hpp 1.2 1994/03/09 11:50:15 kjb Exp $
*
****************************************************************************/

#ifndef	__TFRAME_HPP
#define	__TFRAME_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TFrame class is used to represent the frames drawn around the
// outside of dialog boxes and windows.
//
// If the width of the frame is less than 3, only the active or passive
// colors is used and the frame will not be 3D.
//
// TFrame's are meant to belong to either TDialog's or TWindows or any
// of their subclasses, with the first 4 entries in the palette set up
// for the frame colors.
//---------------------------------------------------------------------------

class TFrame : public TView {
	int		width;					// Width of the frame
	bool	solid;					// Draw the frame as solid, not 3d

			// Method to draw a solid frame
			void drawSolid();

public:
			// Constructor
			TFrame(const TRect& bounds,bool solid = false,int width = 4)
				: TView(bounds), solid(solid),
				  width(width * _MVIS_sysLineWidth) {};

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Method to draw the frame
	virtual	void draw(const TRect& clip);

			// Method to compute the inside rectangle for the frame
	virtual	TRect inner();
	};

#endif	// __TFRAME_HPP
