/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tfiledlg.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TFileDialog class. This class is used
*				to represent and dialog box for selecting a file to
*				open, or save, in a standard manner.
*
* $Id: tfiledlg.hpp 1.2 1994/03/09 11:50:15 kjb Exp $
*
****************************************************************************/

#ifndef	__TFILEDLG_HPP
#define	__TFILEDLG_HPP

#ifndef	__TDIALOG_HPP
#include "tdialog.hpp"
#endif

#ifndef	__TINPUTL_HPP
#include "tinputl.hpp"
#endif

#ifndef	__TLIST_HPP
#include "tlist.hpp"
#endif

#ifndef	__ARRAY_HPP
#include "array.hpp"
#endif

#ifndef	__STR_HPP
#include "str.hpp"
#endif

#ifndef	__DIR_H
#include <dir.h>
#endif

/*------------------------------ Constants --------------------------------*/

const ushort

	fdOpenButton	= 0x0001,			// Dialog has an open button
	fdSaveButton	= 0x0002,			// Dialog has a save button
	fdHelpButton	= 0x0004,			// Dialog has a help button
	fdMustExist		= 0x0008,			// The file selected must exist

	fdDirLoaded		= 0x0100,			// The directory is currently loaded

	fdOpenDialog	= fdOpenButton | fdHelpButton,
	fdBrowseDialog	= fdOpenButton | fdHelpButton | fdMustExist,
	fdSaveAsDialog	= fdSaveButton | fdHelpButton;

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TFileDialog class is designed to provide a standard mechanism for
// allowing users to interactively load and save files.
//---------------------------------------------------------------------------

class TFileDialog : public TDialog {
protected:
	ushort		flags;				// Creation flags
	TInputLine	*fileLine;			// Input line holding filename
	TInputLine	*driveSel;			// Input line holding drive
	TList		*fileList;			// TList of available files
	TList		*directoryList;		// TList of available directories
	char		directory[MAXDIR];	// Current directory
	char		filename[MAXPATH];	// Full absolute filename including path
	bool		hasWilds;			// True if filename has wildcards
	ISArray<DynStr>	filenames;		// Array of filenames
	ISArray<DynStr>	directories;	// Array of directories

	static const char *openText;	// Text for standard buttons
	static const char *saveText;
	static const char *helpText;
	static const char *cancelText;
	static const char *typeText;
	static const char *driveText;
	static const char *fileText;
	static const char *directoryText;
	static const char *invalidDriveText;
	static const char *invalidFileText;
	static const char *tooManyFilesText;

			// Method to update the file input line
			void updateFileLine();

			// Method to change to the specified directory
			void changeDirectory();

			// Checks to see if a filename is valid
			bool validFilename(const char *filename);

			// Method to load the current directory's filenames
			void loadFilenames();

public:
			// Constructor
			TFileDialog(const char *defFile,const char *title,
				const char *inputName,ushort flags);

			// Virtual to determine if the view was constructed correctly
	virtual	bool valid(ushort command);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase);

			// Virtual to execute the file dialog
	virtual	ushort execute();

			// Method to get the filename
			const char *getFilename() const	{ return filename; };
			void setFilename(const char *filename,bool loadCWD = false);
	};

#endif	// __TFILEDLG_HPP
