/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tdesktop.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TProgram class.
*
* $Id: tdesktop.cpp 1.2 1994/03/09 11:50:31 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tdesktop.hpp"

/*----------------------------- Implementation ----------------------------*/

TDeskTop::TDeskTop(const TRect& bounds,TBackGround *backGround)
	: TGroup(bounds), backGround(backGround)
/****************************************************************************
*
* Function:		TDeskTop::TDeskTop
* Parameters:	bounds		- Bounding rectangle for the desktop
*				backGround	- Pointer to background view to use
*
* Description:
*
****************************************************************************/
{
	if (backGround)
		backGround->setOwner(this);
}

void TDeskTop::handleEvent(TEvent& event,phaseType phase)
/****************************************************************************
*
* Function:		TDeskTop::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TDesktop class. Here we
*				handle the events to move the active window.
*
****************************************************************************/
{
	TGroup::handleEvent(event,phase);

	// Here we handle the cmNext, cmPrev messages.
}

void TDeskTop::drawBackground(const TRect& clip)
/****************************************************************************
*
* Function:		TDeskTop::drawBackground
* Parameters:	clip	- Clipping rectangle for the view.
*
* Description:	Draws the desktop's background if present.
*
****************************************************************************/
{
	if (backGround)
		backGround->draw(clip);
}
