/*
 * grafix --- grafsys.h
 *
 * definitions for communication between graf.c and drivers
 *
 * Written 4/87 by Scott Snyder (ssnyder@romeo.caltech.edu or @citromeo.bitnet)
 *
 */

/*
 * the assembly routines assume that all the global data is in the default
 *  data segment. in MSC's large (& compact) model, however, each module
 *  gets its own data segment --- except stuff declared near which goes
 *  into the default segment. TC, however, doesn't allow near, etc. to
 *  modify static data. but TC also puts all static data into one segment
 *  in all models except huge. so we get lucky this time!
 */

#if defined(__TURBOC__)
# define NEAR
#else
# define NEAR near
#endif

/* display type definitions */

#define EN 1
#define CD 2
#define MO 3

/* graphics mode definitions */

#define CGA_640 1
#define CGA_320 2

typedef unsigned char g_obj;

/* physbuf = area that's being displayed;
   virtbuf = other area;
   drawbuf = area that's being drawn on
*/

extern g_obj far * NEAR g_drawbuf; /* graphics drawing buffer */
extern g_obj far * NEAR g_physbuf; /* addr. of physical screen buffer */
extern g_obj far * NEAR g_virtbuf; /* addr. of virtual buffer */
extern unsigned NEAR g_colormax; /* maximum color value     */
extern unsigned NEAR g_xsize, NEAR g_ysize; /* physical size of screen */
extern unsigned NEAR g_xchsize, NEAR g_ychsize; /* size of screen in chars */
extern unsigned NEAR g_xor;     /* xor mode flag */
extern unsigned NEAR g_bufflg;	/* buffered mode flag */
extern int NEAR g_xcliplo, NEAR g_xcliphi; /* clipping boundaries */
extern int NEAR g_ycliplo, NEAR g_ycliphi;
extern float NEAR g_aspect;	/* aspect ratio for circle drawing */
extern unsigned NEAR g_pages;	/* number of pages available	   */
extern unsigned NEAR g_curpage;	/* page currently visible	   */
extern unsigned NEAR g_display;	/* display type		           */

/* utility functions */

extern g_fmemset(g_obj far *, g_obj, unsigned);
extern g_fmemcpy(g_obj far *, g_obj far *, unsigned);
extern unsigned g_bufseg(void);

/* driver functions */

#include "cga.h"
#include "ega.h"
